import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { GCache } from '../../libs/tc/util/GCache';
import { NetName } from '../../libs/tw/enum/NetName';
import { NetManager } from '../../libs/tw/manager/NetManager';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { Buried } from '../../libs/tw/util/Buried';
export default class StartScene1 extends Scene {
    public mainbg:eui.Image;
    public ruleBtn:eui.Button;
    public prizeBtn:eui.Button;
    public shareBtn:eui.Button;
    public timesLb:eui.Label;
    public timesLb0:eui.Label;
    public startBtn:eui.Button;
    public shareGroup:eui.Group;
    
    private isShare:boolean;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);

        this.shareGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareGroup, this);
    }

    removeEvents() {
        super.removeEvents();

        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);

        this.shareGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareGroup, this);
    }


    private shareToIdx:number;
    onTap_shareBtn(){
        PanelCtrl.instance.btnDelay(this.shareBtn);
        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);

        this.shareGroup.visible = true;
        if(!this.isShare){//是否分享过
            this.shareToIdx = setTimeout(() => {
                NetManager.ins.shareAction((success)=>{
                    if(success){
                        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '分享成功！'});
                        NetManager.ins.getHomeInfo(()=>{
                            let data = DataManager.ins.getData(NetName.GET_HOME_INFO).data;
                            if(data && data.remainingNum){
                                this.timesLb.text = '今日免费次数:' + data.remainingNum;
                                this.isShare = data.isShare;
                                this.timesLb0.text = '分享好友可每日增加' + data.shareNum + '次机会';
                            }
                        })
                    }else{
                        let data = DataManager.ins.getData(NetName.SHARE_ACTION);
                        if(data && data.code == '100002'){
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '活动未开始'});
                        }else if(data && data.code == '100003'){
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '活动已结束'});
                        }else if(data && data.code == '100005'){
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '今日参与次数已达上限'});
                        }else if(data && data.code == '510001'){
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '今日抽奖次数已达上限'});
                        }else{
                            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '加次数失败！'});
                        }
                    }
                });
            }, 2000);
        }
       
    }

    private onTap_shareGroup():void{
        PanelCtrl.instance.btnDelay(this.shareGroup);
        this.shareGroup.visible = false;
        if(this.shareToIdx){
            clearTimeout(this.shareToIdx)
        }
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad(); 
        }
    }

    private onLoad(): void {

        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.showLog(exposure);

        startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.showLog(exposure);

        startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.showLog(exposure);

        this.initUI();
    }

    private initUI():void{
        this.timesLb.text = '今日免费次数:0';
        this.timesLb0.text = '分享好友可每日增加0次机会';
        let data = DataManager.ins.getData(NetName.GET_HOME_INFO).data;
        if(data){
            this.timesLb.text = '今日免费次数:' + data.remainingNum;
            this.isShare = data.isShare;
            this.timesLb0.text = '分享好友可每日增加' + data.shareNum + '次机会';
        }

        this.shareGroup.visible = false;

        PanelCtrl.instance.isLoseCoin = false;
        egret.Tween.get(this.startBtn, {loop:true})
            .to({scaleX:1.05, scaleY:1.05}, 150)
            .to({scaleX:0.9, scaleY:0.9}, 150)
            .to({scaleX:1.05, scaleY:1.05}, 150)
            .to({scaleX:0.9, scaleY:0.9}, 150).wait(500);

    }

    private onTap_ruleBtn():void{
        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL); 
        
    }

    private onTap_startBtn():void{
        PanelCtrl.instance.btnDelay(this.startBtn);

        NetManager.ins.doJoin((success:boolean)=>{
            if(success){
                this.goGame();
            }else{
                console.log('dojoin报错了')
                PanelCtrl.instance.isLoseCoin = true;

                let data = DataManager.ins.getData(NetName.DO_JOIN);
                if(data && data.code == '100002'){
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '活动未开始'});
                }else if(data && data.code == '100003'){
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '活动已结束'});
                }else if(data && data.code == '100005'){
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, {text0:'挑战次数用完了~', text1:'', type:2});
                }else if(data && data.code == '510001'){
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '今日抽奖次数已达上限'});
                }else{
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '网络异常'});
                }
            }
        });
    }

    //首页点击埋点
    private onTap_this():void{
    }

    private dostart(): void {
        // Loading.instace.show();
        
    }

    //跳转游戏页
    private goGame(isdemo:boolean = false):void{
        const isfirst = GCache.readCache('showGuide');
        if (!isfirst) {
            GCache.writeCache('showGuide', 'true');
            PanelCtrl.instance.show(ModuleTypes.GUIDE_PANEL);
        }else{
            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
        }
    }

    private onTap_prizeBtn():void{
        console.log('点击prizeBtn'); 
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
        NetManager.ins.clickLog(exposure);

        window.location.href = window['prizeUrl'] ? window['prizeUrl'] : 'http://activity.m.duibadev.com.cn/projectx/p88773312/f79cc316e.html';
    }

    

    //循环播放动画
	private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean = true): void {
		if (isLoop) {
			for (var key in target.items) {
				target.items[key].props = { loop: true };
			}
		}
		target.play();
    }
    

}
