import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import PanelCtrl from "../ctrls/panelCtrl";
export default class RankPanel extends Panel {
    public rankScroller:eui.Scroller;
    public rankGroup:eui.Group;
    public prizeBtn:eui.Button;
    public closeBtn:eui.Button;

    public intoRankLb0:eui.Label;
    public nickNameLb:eui.Label;
    public intoRankLb1:eui.Label;
    public totalScoreLb:eui.Label;

    private rankTimesPlugId:number;

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data: any) {
        super(data);
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);
    }

    private onLoad():void{
        this.rankTimesPlugId = window['rankTimesPlugId'] ? window['rankTimesPlugId'] : 5555;
        this.initUI();
    }

    private initUI():void{

        this.prizeBtn.touchEnabled = false;

        
    }



    private onTap_prizeBtn():void{
        console.log('点击了立即领取');
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        this.getPlugPrize(this.rankTimesPlugId);
    }
    
    /**
     * 抽首页插件
     * @param idx 插件顺序
     */
    private getPlugPrize(activityId:number):void{

        Loading.instace.show();
        NetManager.ins.doJoinPlugDraw((isSuccess: boolean) => {
            if (isSuccess) {
                NetManager.ins.getPlugOrderStatus((data) => {
                    if (data == 'pollingFaild' || !data) {
                        console.log('轮询失败：' + data);
                        Loading.instace.hide();
                    }else{//出奖
                        Loading.instace.hide();

                        this.prizeBtn.touchEnabled = false;
                        this.prizeBtn.currentState = 'disabled';

                        //弹出奖品框待处理
                        PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL,{callback:function(){}.bind(this), lottery:null});
                    }
                }, DataManager.ins.doJoinPlugDrawData.orderId, () => {
                    return (DataManager.ins.getPlugOrderStatusData.result == 0)
                }, 10)
            } else {
                // 下订单失败
                console.log('抽插件下单失败：' + activityId);
                Loading.instace.hide();
            }
        }, activityId);

    }
}