import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class PrizePanel extends Panel {
    private mdata: any;
    public tipsLb: eui.Label;
    public prizeImg: eui.Image;
    public iknowBtn: eui.Button;
    public prizeNameLb: eui.Label;

    private isplug: boolean;
    private lottery: any;
    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function () {

        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    removeEvents(): void {
        super.removeEvents();
        if (this.iknowBtn) {
            this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
        if (this.prizeImg) {
            this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
    }

    private onLoad() {

        let startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.showLog(exposure);
        this.prizeNameLb.text = '';

        this.lottery = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
        if (this.lottery && this.lottery.length > 0) {
            this.lottery = this.lottery[0];
        } else {
            this.lottery = null;
        }

        if (this.lottery) {

            this.prizeNameLb.text = this.lottery.name;//511 239
            this.prizeImg.source = this.lottery.icon;

            switch (this.lottery.refType) {
                case LotteryType.VIRTUAL:
                case LotteryType.OBJECT:
                case LotteryType.ALIPAY:
                case LotteryType.PHONEBILL:
                case LotteryType.QB:
                    this.prizeImg.x = 253;
                    this.prizeImg.y = 518;

                    this.prizeImg.width = 245;
                    this.prizeImg.height = 245;
                    break;

                case LotteryType.THANKS:

                    break;

                default:

                    this.prizeImg.x = 115;
                    this.prizeImg.y = 518;

                    this.prizeImg.width = 522;
                    this.prizeImg.height = 245;
                    break;
            }
        }
    }


    onUse() {
        let pData = DataManager.ins.getData(NetName.DRAW_JOIN).data;
        window.location.href = pData.url;
    }

    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        NetManager.ins.getHomeInfo((success1) => {
            if (success1) {

            } else {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '网络异常，请稍后再试~' });
            }

            SceneCtrl.instance.change(ModuleTypes.START_SCENE);

        });

    }

    private onTap_ok(e: egret.TouchEvent): void {

        let startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.onUse();
        // this.hidePanel();
        // this.onTouchTap();
    }

}