
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import TopLayerCtrl from "../ctrls/topLayerCtrl";

export default class MsgPanel extends Panel {
    public okBtn:eui.Button;
    public againBtn:eui.Button;
    public msgTxt01:eui.Label;
    public msgTxt02:eui.Label;
    private mData:any;


    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    private onLoad():void{

        // this.msgTxt01.visible = false;
        // this.msgTxt02.visible = false;
        this.againBtn.visible = false;

        if(this.mData){
            this.msgTxt01.text = this.mData.text0;
            this.msgTxt02.text = this.mData.text1;
        }

        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);
        
        this.onTouchTap();
    }

    private onTap_againBtn():void{
        PanelCtrl.instance.btnDelay(this.againBtn);
        this.onTouchTap();
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        if(this.mData && this.mData.type != 2){
            NetManager.ins.getHomeInfo((success1) => {
                if(success1) {
    
                } else {
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '网络异常，请稍后再试~'});
                }
    
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    
            });
        }
        

    }


}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}