import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
import TopLayerCtrl from "../ctrls/topLayerCtrl";
export default class GameOverPanel extends Panel {
    public okBtn:eui.Button;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{
        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);

        SceneCtrl.instance.change(ModuleTypes.START_SCENE);

        this.onTouchTap();
        
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        NetManager.ins.getHomeInfo((success1) => {
            if(success1) {

            } else {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg: '网络异常，请稍后再试~'});
            }

            SceneCtrl.instance.change(ModuleTypes.START_SCENE);

        });
    }

    onUse() {
    }
}