import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class AgainPanel extends Panel {

    private mdata:any;
    public againBtn:eui.Button;

    private img:any;
    public get skinKey() { return 'AgainPanel' }
    public get groupName() { return 'again_panel'}
    
    constructor(data){
        super(data);

        this.mdata = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        

        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);

    }

    removeEvents():void{
        super.removeEvents();
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.againBtn);

        this.onTouchTap();

    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        
        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
    }
}