import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { GCache } from '../../libs/tc/util/GCache';
import { NetName } from '../../libs/tw/enum/NetName';
export default class StartScene extends Scene {
    public mainbg: eui.Image;
    public ruleBtn: eui.Button;
    public startBtn: eui.Button;


    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);//95fcf3
    }

    initEvents() {
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_this, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
    }


    onTap_shareBtn() {
        window.location.href = `http://www.abchina.com/luascript/shareOnClick/{"return":{"share_title":"中国农业银行无感支付","share_text":"无感支付是一种不需刷卡，抬杆即走的快捷支付产品","share_url":"http://wechatshare.com?id=000001","share_img_url":"https://enjoy.abchina.com/yh-web/file/download/UINB28289CNA289NA3"}}`
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

    }

    private onLoad(): void {
        this.initUI();
    }

    private initUI(): void {
        PanelCtrl.instance.isLoseCoin = false;
        egret.Tween.get(this.startBtn, { loop: true })
            .to({ scaleX: 1.05, scaleY: 1.05 }, 150)
            .to({ scaleX: 0.9, scaleY: 0.9 }, 150)
            .to({ scaleX: 1.05, scaleY: 1.05 }, 150)
            .to({ scaleX: 0.9, scaleY: 0.9 }, 150).wait(500);

    }

    private onTap_ruleBtn(): void {
        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    private onTap_startBtn(): void {
        PanelCtrl.instance.btnDelay(this.startBtn);
        window.location.href = "https://a.app.qq.com/o/simple.jsp?pkgname=com.android.bankabc&ios_scheme=bankabc%3a%2f%2f%257b%2522param%2522%253a%2522%2522%252c%2522method%2522%253a%2522jumpToSharedProduct%2522%257d&android_scheme=bankabc%3a%2f%2f%257b%2522param%2522%253a%2522%2522%252c%2522method%2522%253a%2522jumpToSharedProduct%2522%257d";
    }

    //首页点击埋点
    private onTap_this(): void {
    }

    //循环播放动画
    private playAnimation(target: egret.tween.TweenGroup, isLoop: boolean = true): void {
        if (isLoop) {
            for (var key in target.items) {
                target.items[key].props = { loop: true };
            }
        }
        target.play();
    }


}
