import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
export default class SorryPanel extends Panel {
    public okBtn:eui.Button;
    public prizeImg:eui.Image;
    public prizeNameLb:eui.Label;
    private mData:any;
    private lottery:any;

    public get skinKey() { return 'SorryPanel' }
    public get groupName() { return 'sorry_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{
        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);

        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        this.hidePanel();

        this.onUse();
        this.onTouchTap();
        
    }

    onTouchTap():any{
        super.onTouchTap();
        
    }
}