import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
export default class InputPhonePanel extends Panel {
    public closeBtn:eui.Button;
    public sureBtn:eui.Button;
    public inputGroup:eui.Group;
    

    private mData:any;

    public get skinKey() { return 'InputPhonePanel' }
    public get groupName() { return 'inputphone_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
            this.onLoad();
            this.initInput()
        }
    }

    myEditableText: eui.EditableText = new eui.EditableText();

    initInput() {
        this.myEditableText.text = "";
        //指定文本的颜色。
        this.myEditableText.textColor = 0x999595;
        //指定我们的文本输入框的宽和高    
        this.myEditableText.width = this.inputGroup.width;
        this.myEditableText.height = this.inputGroup.height;
        this.myEditableText.x = 0;
        this.myEditableText.y = 0;
        this.myEditableText.size = 28;
        this.myEditableText.lineSpacing = 68;
        this.myEditableText.textAlign = "left";
        this.myEditableText.verticalAlign = "middle";
        this.myEditableText.maxChars = 11
        this.myEditableText.restrict = "0-9";
        this.myEditableText.prompt = "请输入注册掌银的手机号"
        this.inputGroup.addChild(this.myEditableText);
      //  this.myEditableText.addEventListener(egret.Event.CHANGE,this.onFocusOut_myEditableText,this)
       
    }

    onFocusOut_myEditableText(){
        this.myEditableText.text=this.myEditableText.text.replace(/^\s*|\s*$/g,"")
        if(this.myEditableText.text.length<11){
            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请输入正确手机号'});
        }
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.sureBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_sureBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.sureBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_sureBtn, this);
    }

    private onLoad():void{
        
    }

    onTap_sureBtn(){
        this.myEditableText.text=this.myEditableText.text.replace(/^\s*|\s*$/g,"")
        if(this.myEditableText.text.length<11){
            this["showTips"].play(0)
            return;
        }
        
        NetManager.ins.submitPhone(()=>{

        },window["CFG"].actId,this.myEditableText.text)

        PanelCtrl.instance.btnDelay(this.closeBtn)
        this.onTouchTap()
    }

    onTouchTap():any{
        PanelCtrl.instance.btnDelay(this.closeBtn)
        super.onTouchTap();
    }
}