import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
export default class InputPhonePanel extends Panel {
    public closeBtn:eui.Button;
    public confirmBtn:eui.Button;
    public inputGroup:eui.Group;
    

    private mData:any;

    public get skinKey() { return 'InputPhonePanel' }
    public get groupName() { return 'inputphone_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
            this.onLoad();
            this.initInput()
        }
    }

    myEditableText: eui.EditableText = new eui.EditableText();

    initInput() {
        this.myEditableText.text = "";
        //指定文本的颜色。
        this.myEditableText.textColor = 0x999595;
        //指定我们的文本输入框的宽和高    
        this.myEditableText.width = this.inputGroup.width;
        this.myEditableText.height = this.inputGroup.height;
        this.myEditableText.x = 0;
        this.myEditableText.y = 0;
        this.myEditableText.size = 32;
        this.myEditableText.lineSpacing = 68;
        this.myEditableText.textAlign = "center";
        this.myEditableText.verticalAlign = "middle";
        this.myEditableText.maxChars = 6
        this.myEditableText.prompt = "请输入你的昵称"
        this.inputGroup.addChild(this.myEditableText);
        this.myEditableText.addEventListener(egret.Event.CHANGE,this.onFocusOut_myEditableText,this)
        this.onFocusOut_myEditableText()
    }

    onFocusOut_myEditableText(){
        this.myEditableText.text=this.myEditableText.text.replace(/^\s*|\s*$/g,"")
        if(this.myEditableText.text==""){
           // this.startBtn.enabled=false;
        }else{
        }
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.confirmBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_confirmBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
        this.confirmBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_confirmBtn, this);
    }

    private onLoad():void{
        
    }

    onTap_confirmBtn(){

    }

    onTouchTap():any{
        PanelCtrl.instance.btnDelay(this.closeBtn)
        super.onTouchTap();
    }
}