import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
export default class InputPhonePanel extends Panel {
    public closeBtn:eui.Button;
    public confirmBtn:eui.Button;

   
    private mData:any;

    public get skinKey() { return 'InputPhonePanel' }
    public get groupName() { return 'inputphone_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.confirmBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.confirmBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTouchTap, this);
    }

    private onLoad():void{
        
    }

    onTouchTap():any{
        PanelCtrl.instance.btnDelay(this.confirmBtn)
        super.onTouchTap();
    }
}