import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
export default class PrizePanel extends Panel {
    private mdata: any;
    public tipsLb:eui.Label;
    public prizeImg: eui.Image;
    public iknowBtn: eui.Button;
    public prizeNameLb: eui.Label;

    private isplug:boolean;
    private lottery:any;
    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;

        if(this.mdata){
            this.isplug = this.mdata.isplug;
            if(this.isplug){
                this.lottery = DataManager.ins.getPlugOrderStatusData.lottery;
            }else{
                this.lottery = DataManager.ins.getCustomOrderStatusData.lottery;
            }
        }
    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function(){
            
        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        
    }

    removeEvents(): void {
        super.removeEvents();
        if(this.iknowBtn){
            this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
        if(this.prizeImg){
            this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        }
    }

    private onLoad() {

        if(this.mdata && this.lottery){
            var url: string;

            url = this.lottery.img;
            this.prizeImg.name = 'img'

            this.prizeNameLb.text = this.lottery.name;//511 239
            this.prizeImg.source = url;
            
            switch(this.lottery.type){
                case LotteryType.VIRTUAL:
                case LotteryType.OBJECT:
                case LotteryType.ALIPAY:
                case LotteryType.PHONEBILL:
                case LotteryType.QB:
                    this.prizeImg.x = 253;
                    this.prizeImg.y = 358;

                    this.prizeImg.width = 245;
                    this.prizeImg.height = 245;
                break;

                case LotteryType.THANKS:
                    
                break;

                default:

                    this.prizeImg.x = 115;
                    this.prizeImg.y = 358;

                    this.prizeImg.width = 522;
                    this.prizeImg.height = 245;
                break;
            }
        }
    }

    private onTap(): void {
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        this.hidePanel();
    }


    onUse() {
        if(this.mdata){
            const lottery = this.lottery;
            // if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            if (lottery.type == LotteryType.LUCKY) {

                window["downloadAppConfig"] =
                    {
                        openUrl: lottery.openUrl,
                        iosDownloadUrl: lottery.iosDownloadUrl,
                        androidDownloadUrl: lottery.androidDownloadUrl,
                        confirm: lottery.confirm ? lottery.confirm : false
                    };
                window["downloadApp"]();
                if (lottery.type == "lucky") {
                    if(this.isplug){
                        NetManager.ins.spmclick(DataManager.ins.getPlugOrderStatusData.exposure);
                    }else{
                        NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
                    }
                }
            } else {
                console.log(`领奖链接：${lottery.link}`)
                window.location.href = lottery.link;
            }
        }else{
            // this.onTouchTap();
        }
    }

    onTouchTap(): any {
        super.onTouchTap();
        if (this['closeBtn']) {
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        
        Loading.instace.show();

        NetManager.ins.ajaxElementNew(function(success){
            console.log(DataManager.ins.ajaxElementDataNew);
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                // console.log('errorCode:' + DataManager.ins.doJoinData.code);
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试', line: 1});
                // PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL, {idx:1});
                Loading.instace.hide();
            }
        }.bind(this));


        this.onTap();
    }

    private onTap_ok(e:egret.TouchEvent):void{
        this.onUse();

        // window.location.href = window['prizeUrl'] ? window['prizeUrl'] : 'http://www.baidu.com';
        this.onTouchTap();
    }

}