
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";

export default class MsgPanel extends Panel {
    public okBtn:eui.Button;
    public againBtn:eui.Button;
    public msgTxt1:eui.Label;
    public msgTxt0:eui.Label;
    private mData:any;


    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.againBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.againBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_againBtn, this);
    }

    private onLoad():void{

        this.msgTxt1.visible = false;
        this.msgTxt0.visible = false;

        if(this.mData){
            if(this.mData.type == 0){
                this.msgTxt0.visible = true;
                this.againBtn.visible = false;
                this.okBtn.visible = true;
            }else if(this.mData.type == 1){
                this.msgTxt1.visible = true;
                this.againBtn.visible = true;
                this.okBtn.visible = false;
            }

        }

        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);
        
        this.hidePanel();
    }

    private onTap_againBtn():void{
        PanelCtrl.instance.btnDelay(this.againBtn);
        this.onTouchTap();
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        this.getAjax();
    }

    private getAjax():void{
        Loading.instace.show();
        NetManager.ins.ajaxElementNew(function(success){
            console.log(DataManager.ins.ajaxElementDataNew);
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            }else{
                // console.log('errorCode:' + DataManager.ins.doJoinData.code);
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试', line: 1});
                // PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL, {idx:1});
                Loading.instace.hide();
            }
        }.bind(this));
    }

}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}