import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { LotteryType } from "../../libs/tw/enum/LotteryType";
export default class GameOverPanel extends Panel {
    public okBtn:eui.Button;
    public prizeImg:eui.Image;
    public prizeNameLb:eui.Label;
    private mData:any;
    private lottery:any;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
        this.lottery = DataManager.ins.getCustomOrderStatusData.lottery;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.prizeImg.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        this.prizeImg.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        var url: string;

        url = this.lottery.img;
        this.prizeImg.name = 'img'

        this.prizeNameLb.text = this.lottery.name;//511 239
        this.prizeImg.source = url;
        
        switch(this.lottery.type){
            case LotteryType.VIRTUAL:
            case LotteryType.OBJECT:
            case LotteryType.ALIPAY:
            case LotteryType.PHONEBILL:
            case LotteryType.QB:
                this.prizeImg.x = 253;
                this.prizeImg.y = 409;

                this.prizeImg.width = 245;
                this.prizeImg.height = 245;
            break;

            case LotteryType.THANKS:
                
            break;

            default:

                this.prizeImg.x = 113;
                this.prizeImg.y = 409;

                this.prizeImg.width = 522;
                this.prizeImg.height = 245;
            break;
        }
        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);

        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        this.hidePanel();

        this.onUse();
        this.onTouchTap();
        
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        let times = DataManager.ins.ajaxElementDataNew.element.freeLimit - 1;
        if(times < 0){
            times = 0;
        }
        DataManager.ins.ajaxElementDataNew.element.freeLimit = times;
    }

    onUse() {
        let lottery = this.lottery;
        if(!lottery) return;

        if (lottery.type == LotteryType.LUCKY) {

            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == "lucky") {
                NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            }
        } else {
            console.log(`领奖链接：${lottery.link}`)
            window.location.href = lottery.link;
        }
    }
}