import ComponentBase from "../components/ComponentBase";

export default class Scene extends ComponentBase {
    protected onSkinComplete() {
        super.onSkinComplete();
        this.createLayers();
    }

    private _map: { [key: string]: egret.Sprite }
    createLayers() {
        this._map = {};
        for (const key of this.layerKeys) {
            const layer = new egret.Sprite();
            this.getLayerParent().addChild(layer);
            this._map[key] = layer;
        }
    }

    getLayerParent(): egret.DisplayObjectContainer {
        return null;
    }

    getLayer(key) {
        return this._map[key]
    }

    protected get layerKeys() {
        return []
    }


}