import getIsIOS from "../../libs/new_tc/getIsIOS";
import doStart from "../../libs/new_tw/ctrls/doStart";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "../views/Scene";
import getCountTxt from "./data/getCountTxt";
import getStartBtnEnable from "./data/getStartBtnEnable";
import { LayerTypesList } from "./data/LayerTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";

export default class StartScene extends Scene {
    start(data?) {
        this.height = this.stage.stageHeight;
        this.countTxt.visible = false;
        this.startBtn.visible = false;
        this.updateGetInfoView();
        this.updateExemptionTxt();
    }

    private updateGetInfoView() {
        if (DataManager.ins.getInfoData) {
            this.updateStartBtnStatus();
            this.updateCountTxt();
        } else {
            DataManager.ins.once('dataUpdate', this.updateGetInfoView, this);
        }
    }

    updateStartBtnStatus() {
        if (!this.startBtn) return;
        this.startBtn.visible = true;
        this.startBtn.enabled = getStartBtnEnable();
        egret.Tween.get(this.startBtn).set({ horizontalCenter: 750 }).to({ horizontalCenter: 0 }, 400, egret.Ease.elasticOut);
    }

    updateCountTxt() {
        if (!this.countTxt) return;
        this.countTxt.visible = true;
        this.countTxt.text = getCountTxt();
        egret.Tween.get(this.countTxt).set({ horizontalCenter: 750 }).wait(400).to({ horizontalCenter: 0 }, 300, egret.Ease.backOut);
    }

    updateExemptionTxt() {
        if (this.exemptionTxt) {
            if (getIsIOS()) {
                this.exemptionTxt.visible = true;
            } else {
                this.exemptionTxt.visible = false;
            }
        }
    }

    initEvents() {
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.addTimesBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_addTimesBtn, this);
        this.recordBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_recordBtn, this);
        this.startBtn.once(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
    }

    onTap_ruleBtn(e: egret.Event) {
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
    }

    onTap_addTimesBtn(e: egret.Event) {

    }

    onTap_recordBtn(e: egret.Event) {

    }

    onTap_startBtn(e: egret.Event) {
        doStart();
        SceneCtrl.instance.change(ModuleTypes.PALY_SCENE);
    }

    protected get layerKeys() {
        return LayerTypesList;
    }

    countTxt: eui.Label;
    exemptionTxt: eui.Label;

    recordBtn: eui.Button;
    startBtn: eui.Button;
    ruleBtn: eui.Button;
    addTimesBtn: eui.Button;

    protected get skinKey() { return 'Start' }
    getLayerParent() { return this.wrapper; }
    wrapper: eui.Group;
}