const bulletNumsMax = 20;//一秒20发
export const getBulletData = (X) => {
    if (X <= 20) return { nums: getBulletData20(X), line: 1 };
    if (X <= 40) return getBulletData40(X);
    if (X <= 60) return getBulletData60(X);
    if (X <= 80) return getBulletData80(X);
    if (X <= 100) return getBulletData100(X);
    if (X <= 120) return getBulletData120(X);
    if (X <= 140) return getBulletData140(X);
    return getBulletData140(X);
}

const getBulletData20 = (X) => { //X  0 - 20
    const bulletNumsMin = 10;
    let result = (bulletNumsMax - bulletNumsMin) + (bulletNumsMax - bulletNumsMin) * X / bulletNumsMax;
    return Math.floor(result)
}

const getBulletData40 = (X) => { //X  20-40
    if (X <= 30) {
        return [{ nums: bulletNumsMax, line: 1 }, { nums: bulletNumsMax, line: 2 }]
    }
    return { nums: bulletNumsMax, line: 2 };
}

const getBulletData60 = (X) => { //X  40-60
    if (X <= 50) {
        return [{ nums: bulletNumsMax, line: 2 }, { nums: bulletNumsMax, line: 3 }]
    }
    return { nums: bulletNumsMax, line: 3 };
}


const getBulletData80 = (X) => { //X  60-80
    if (X <= 70) {
        return [{ nums: bulletNumsMax, line: 3 }, { nums: bulletNumsMax, line: 4 }]
    }
    return { nums: bulletNumsMax, line: 4 };
}

const getBulletData100 = (X) => { //X  80-100
    if (X <= 90) {
        return [{ nums: bulletNumsMax, line: 4 }, { nums: bulletNumsMax, line: 5 }]
    }
    return { nums: bulletNumsMax, line: 5 };
}

const getBulletData120 = (X) => {
    if (X <= 110) {
        return [{ nums: bulletNumsMax, line: 5 }, { nums: bulletNumsMax, line: 6 }]
    }
    return { nums: bulletNumsMax, line: 6 };
}

const getBulletData140 = (X) => {
    if (X <= 130) {
        return [{ nums: bulletNumsMax, line: 6 }, { nums: bulletNumsMax, line: 7 }]
    }
    return { nums: bulletNumsMax, line: 7 };
}