import Body from "./Body";
import PlayScene from "./PlayScene";

export default class World extends egret.Sprite {
    view:PlayScene;
    constructor(view) {
        super();
        this.touchEnabled = false;
        this.view = view;

        this.physicsList = [];
    }

    timer;
    updateFunc() {
        if (this.timer === 0) return;
        this.physicsList.forEach(body => {
            body.updateFunc();
            this.collideWorld(body);

        });
        requestAnimationFrame(this.updateFunc.bind(this));
    }

    pause() {
        this.clearTimer();
    }

    resume() {
        this.timer = 1;
        this.updateFunc();
    }

    clearTimer() {
        this.timer = 0;
    }

    physicsList: Body[];
    addPhysics(item: Body) {
        this.physicsList.push(item);
        this.addChildAt(item, 0);
    }

    removePhysics(item: Body, removeChild = true) {
        const i = this.physicsList.indexOf(item);
        if (i != -1) this.physicsList.splice(i, 1);
        removeChild && this.removeChild(item);
    }

    collideCar(body: Body) {
        let xDistance0 = body.rect.width / 2 + 25 / 2;//this.view.car.width=55 炮筒
        let yDistance0 = body.rect.height / 2 + 72 / 2;
        const xDistance = Math.abs(body.x - this.view.car.x);
        const yDistance = Math.abs(body.y - (this.view.car.y + 122 / 2));
        const collide = xDistance < xDistance0 && yDistance < yDistance0;
        if (collide) {
            body.handleCollide('collideCar', body);
        }
        return collide;
    }

    /**
     * @param body1 
     * @param body2 
     */
    collide(body1: Body, body2: Body) {
        let xDistance0 = body1.rect.width / 2 + body2.rect.width / 2;
        let yDistance0 = body1.rect.height / 2 + body2.rect.height / 2;
        const xDistance = Math.abs(body1.x - body2.x);
        const yDistance = Math.abs(body1.y - body2.y);
        const collide = xDistance < xDistance0 && yDistance < yDistance0;
        if (collide) {
            body1.handleCollide('collide', body2);
            body2.handleCollide('collide', body1);
        }
        return collide;
    }

    static h = 1206 - 110;
    /**
     * 刚体和世界的边缘碰撞
     * @param body 
     */
    private collideWorld(body: Body) {
        if (!body.collideWorldBounds) return;

        if (body.x + body.anX <= 0) { //left 碰撞
            body.velocityX = -body.velocityX * body.bounceX;
            body.x = -body.anX;
        }
        if (body.x - body.anX >= 750) {
            body.x = 750 + body.anX;
            body.velocityX = -body.velocityX * body.bounceX;
        }
        if (this.collideWorldTop(body)) {
            body.y = -body.anY;
            body.velocityY = -body.velocityY * body.bounceY;
        }
        if (this.collideWorldBottom(body)) {
            body.y = World.h + body.anY;
            body.velocityY = -body.velocityY * body.bounceY;
            body.handleCollide('collideWorldBottom');
        }
    }

    collideWorldTop(body: Body) {
        return body.y + body.anY <= 0;
    }

    collideWorldBottom(body: Body) {
        return body.y - body.anY >= World.h;
    }
}