import Scene from "../views/Scene";
import Ball from "./Ball";
import Bullet from "./Bullet";
import CarView from "./CarView";
import Drop from "./Drop";
import Guide from "./Guide";
import World from "./World";
import { getBulletData } from "./datas/getBulletData";

export default class PlayScene extends Scene {
    private _world: World;
    private _carBullet: number;
    private _carFire: number;
    start(data?) {
        this.height = this.stage.stageHeight;
        this.carView = new CarView(this.stage, this.car);
        // Ball.init();
        this._world = new World(this);
        // this.view.addChild(this._world);
        // this._world.addChild(this.view.car);
        // this._world.addChild(this.view.guide1);
        // this._world.addChild(this.view.guide2);

        // const h = (StageManager.ins.height - 1206) / 2;
        // this._world.y = h;

        // this._car = new Car(this.view.car);
        // this.view.car.y = 1206 - this.view.car.height - 110;
        // this.view.guide1.y = this.view.car.y + 50;


        this._carBullet = window['_initCarBullet'] || 0;
        // this.score = 0;
        this._carFire = 100;

        this.updateScoreTxt();

        this._guide = new Guide(this);
    }

    resume() {
        this._running = 1;
        this.updateFunc();
        // this.view.car.ani1.play();
        // resumeCheckAddBall(this);
        this._world.resume();
    }

    pause() {
        this._running = 0;
        // this.removeDrag && this.removeDrag();
        // this.view.car.ani1.stop();
        // this._world.pause();

    }

    updateFunc() {
        if (this._running === 0) return;
        this.collideCar();
        this.collide();
        this.collideWorld();
        this.collideBall();
        this.collideDrops();
        this.updateBulletNums();
        this.checkBallIDs();
        requestAnimationFrame(this.updateFunc.bind(this));
    }

    collideBall() {
        // this._balls.forEach(ball => {
        //     if (this._world.collideWorldBottom(ball))
        //         this.handleCollideWorldBottom(ball);
        // });
    }

    collideDrops() {
        // if (!this._drops) return;
        // for (let i = 0; i < this._drops.length; i++) {
        //     const drop = this._drops[i];
        //     const collideCar = this._world.collideCar(drop);
        //     if (collideCar) {
        //         this._world.removePhysics(drop, false);
        //         const dropsData0 = dropsData[drop.type];
        //         if (dropsData0.hasOwnProperty('bullet'))
        //             this._carBullet += dropsData0.bullet;
        //         if (dropsData0.hasOwnProperty('fire'))
        //             this._carFire += dropsData0.fire;
        //         this.updateScoreTxt();
        //         this._drops.splice(i, 1);
        //         i--;
        //         this._world.addChild(drop);
        //         annie.Tween.to(drop, .5, {
        //             y: drop.y - 200, alpha: 0, onComplete: () => this._world.removeChild(drop)
        //         });
        //     }
        // }
    }

    collideCar() {
        // if (this.isCarProtected) return;
        // const collideCar = this._balls.some(ball => this._world.collideCar(ball));
        // if (collideCar) this.checkGameOver();
    }

    collide() {
        // if (!this._bullets) return;
        // for (let i = 0; i < this._bullets.length; i++) {
        //     const bullet = this._bullets[i];
        //     const collide = this._balls.some(ball => this._world.collide(ball, bullet));
        //     if (collide) {
        //         this._world.removePhysics(bullet);
        //         this._bullets.splice(i, 1);
        //         i--;
        //     }
        // }
    }

    collideWorld() {
        // if (!this._bullets) return;
        // for (let i = 0; i < this._bullets.length; i++) {
        //     const bullet = this._bullets[i];
        //     const collideWorldTop = this._world.collideWorldTop(bullet);
        //     if (collideWorldTop) {
        //         this._world.removePhysics(bullet);
        //         this._bullets.splice(i, 1);
        //         i--;
        //         bullet.handleCollideWorldTop();
        //     }
        // }
    }

    handleCollideWorldBottom(ball: Ball) {
        // if (ball.sizeType >= sizelist.length - 2) vibrate(this.view, () => { });
    }

    onBallDestroy(ball: Ball) {
        // const i = this._balls.indexOf(ball);
        // this._balls.splice(i, 1);
        // this._world.removePhysics(ball);
        // //如果是大球那么分裂
        // //如果是小球那么出掉落
        // if (ball.sizeType == 0) {
        //     this.addDrops(ball);
        // } else {
        //     const nextSizeType = ball.sizeType - 1;
        //     const nextScore = getNextScore(ball.initscore);
        //     const nextColorIndex = ball.nextColorIndex;
        //     const vx = 2;
        //     const vy = -4 * 1.7 * (window['_new_ball_vy_'] || 1);
        //     this.addBall(nextColorIndex, nextSizeType, nextScore, ball.x, ball.y, vx, vy, Ball.gravityY, true, false, ball);
        //     this.addBall(nextColorIndex, nextSizeType, nextScore, ball.x, ball.y, -vx, vy, Ball.gravityY, true, false, ball);
        // }
        // checkAddBall(this);
    }

    _drops: Drop[];
    addDrops(ball: Ball) {
        // this._drops = this._drops || [];
        // const drops0 = Drop.createDrops(ball, this._carBullet);
        // this._drops = this._drops.concat(drops0);
        // for (const i of drops0) {
        //     if (ball['isfirst'])
        //         i.killBlink();
        //     this._world.addPhysics(i);
        //     i.onDisappear = () => {
        //         remove(i, this._drops) && this._world.removePhysics(i);
        //     };
        // }
        // if (ball['isfirst']) {
        //     this.pause();
        //     this._guide.showGuide2(drops0[1].x, drops0[1].y)
        // }
    }

    ballID: number;
    ballIDs: number[];
    checkBallIDs() {
        // for (let i = 0; i < this.ballIDs.length; i++) {
        //     const id = this.ballIDs[i];
        //     const ballIsNotDestroy = this._balls.some(ball => ball.ID == id);
        //     if (this._balls.every(ball => ball.parentID != id) && !ballIsNotDestroy) {
        //         this.ballIDs.splice(i, 1);
        //         i--;
        //         checkAddBall(this);
        //     }

        // }
    }
    addBall(colorIndex, sizeType, score, x, y, vx = 0, vy = 0, gy = 0, collideWorldBounds = true, isParent = false, parent: Ball = null) {
        // this.ballID = this.ballID || 1;
        // this.ballIDs = this.ballIDs || [];
        // const ball = Ball.createBall(colorIndex, sizeType, score);
        // this.balls.push(ball);
        // ball.x = x;
        // ball.y = y;
        // this._world.addPhysics(ball);
        // ball.velocityX = vx;
        // ball.velocityY = vy;
        // ball.gravityY = gy;
        // ball.collideWorldBounds = collideWorldBounds;
        // ball.onDestroy = (ball: Ball) => this.onBallDestroy(ball);
        // ball.onBallShoot = (score: number) => {
        //     this.updateScore(1, score)
        //     this.updateScoreTxt()
        // };

        // if (isParent) {
        //     this.ballID++;
        //     ball.ID = this.ballID;
        //     this.ballIDs.push(ball.ID);
        // }
        // else {
        //     ball.parentID = parent.ID == -1 ? parent.parentID : parent.ID;
        // }
        // return ball;
    }

    _bullets: Bullet[];
    private _bulletNums;
    private _lastBulletTimer = 0;
    private _bulletTimer2 = 0;
    _currentBulletData;
    updateBulletNums() {
        let data = getBulletData(this._carBullet);
        if (!Array.isArray(data))
            data = [data, data];
        if (!this._currentBulletData) {
            this._bulletTimer2 = Date.now();
            this._currentBulletData = data[0];
        }
        const t1 = Date.now() - this._bulletTimer2;
        if (t1 > 500 && t1 < 1000) {
            this._currentBulletData = data[1];
        }
        if (t1 > 1000) {
            this._currentBulletData = data[0];
            this._bulletTimer2 = Date.now();
        }

        this._bulletNums = this._currentBulletData.nums;
        const bulletInterval = 1000 / this._bulletNums;
        const t = Date.now() - this._lastBulletTimer;
        if (t > bulletInterval) {
            this._lastBulletTimer = Date.now();
            for (let i = 0; i < this._currentBulletData.line; i++) {
                let xoffset = 0;
                if (this._currentBulletData.line % 2 == 0) { //2,4
                    //1 2 3 4  --- -1 0 1 2
                    this.addBullet(0, i + 1 - this._currentBulletData.line / 2);
                } else { // 5 
                    const a = Math.ceil(this._currentBulletData.line / 2); // 3
                    xoffset = i + 1 - a;//-2 -1 0 1 2
                    this.addBullet(1, xoffset);
                }

            }
        }
    }
    addBullet(odd, xoffset) {
        const p = 1;
        this._bullets = this._bullets || [];
        const stren = Math.floor(this._carFire / 100);
        const bullet = Bullet.createBullet(stren);
        let targetX;
        if (odd)
            targetX = this.car.x + xoffset * bullet.width * p;
        else
            targetX = this.car.x + xoffset * bullet.width * p - bullet.width * p / 2;
        bullet.x = this.car.x;
        bullet.y = this.car.y;
        egret.Tween.get(bullet).to({ x: targetX, y: bullet.y - 50 }, 100).call(() => {
            bullet.velocityY = -20;
        }, this);
        // annie.Tween.to(bullet, 4, {
        //     useFrame: true, x: targetX, y: bullet.y - 50, onComplete: () => {
        //         bullet.velocityY = -20;
        //     }
        // });
        this._world.addPhysics(bullet);
        this._bullets.push(bullet);
        // playShoot();
    }

    checkGameOver() {
        // this.gameOver();
        this.pause();
    }

    protected submit_result(success: boolean): void {
        // this.enableMouseEvt(true);
        // if (!success) {
        //     return;
        // }
        // NetManager.ins.getCredits(() => { });
        // if (DataManager.ins.gameGetSubmitResultData.lottery)
        //     ModuleManager.ins.openModule('gameOverPrizePanel');
        // else
        //     ModuleManager.ins.openModule('gameOverPanel');
    }

    updateMusicBtns() {
        // this.view.con.musicoff.visible = !getMusicOn();
        // this.view.con.musicon.visible = !this.view.con.musicoff.visible;
    }

    updateScoreTxt() {
        // this.view.con.carFire.text = `${this._carFire}%`;
        // this.view.con.carBullet.text = `${this._carBullet}`;
        // this.view.con.score.text = `${this.score}`;
    }

    removeDrag;
    addDrag() {
        const onmousedown = () => {
            this.carView.startDrag();
            this.addEventListener(egret.TouchEvent.TOUCH_END, onmouseup, this);
        };
        const onmouseup = () => {
            this.carView.stopDrag();
            this.removeEventListener(egret.TouchEvent.TOUCH_END, onmouseup, this);
        };
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, onmousedown, this);
        this.removeDrag = () => {
            this.carView.stopDrag();
            this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, onmousedown, this);
        }
    }

    private _running;
    _guide: Guide;

    protected get layerKeys() {
        return [];
    }

    guide1: eui.Image;
    guide2: eui.Image;

    wrapper: eui.Group;
    car: eui.Group;
    carView: CarView;

    ruleBtn: eui.Button;
    addTimesBtn: eui.Button;
    startBtn: eui.Button;
    recordBtn: eui.Button;
    protected get skinKey() { return 'Play' }
    getLayerParent() { return this; }








}

