export default class CarView {
    stage: egret.Stage;
    car: eui.Group
    constructor(stage: egret.Stage, car: eui.Group) {
        this.stage = stage;
        this.car = car;
    }

    startDrag() {
        this.stage.addEventListener(egret.TouchEvent.TOUCH_MOVE, this.onMove, this)
    }

    stopDrag() {
        this.stage.removeEventListener(egret.TouchEvent.TOUCH_MOVE, this.onMove, this)
    }

    onMove(e: egret.TouchEvent) {
        let x0 = e.stageX;
        if (x0 < 0)
            x0 = 0;
        if (x0 > (750 - 93))
            x0 = 750 - 93;
        console.log(x0);
        this.car.x = x0;
    }
}