import Body from "./Body";

export default class Bullet extends Body {
    strength: number

    handleCollideWorldTop(): any {
        Bullet.recover(this)
    }

    handleCollide(eventName, data: Body) {
        if (eventName == 'collide') {
            Bullet.recover(this)
        }

    }

    static _frees: Bullet[] = [];
    static createBullet(strength) {
        let bullet: Bullet;
        if (Bullet._frees.length > 0) {
            bullet = Bullet._frees.pop();
        } else {
            const cls = window['gamePlaySkin']['Bullet1'];
            const obj = new cls();
            const container = new egret.Sprite();
            container.addChild(obj);
            bullet = new Bullet();
            bullet.addChild(container);
            bullet.view = container;
            const scale = 1.2;
            obj.scaleX = obj.scaleY = scale;
            bullet.rect = new egret.Rectangle(0, 0, obj.width * scale, obj.height * scale);
        }
        bullet.strength = strength;
        return bullet;
    }

    static recover(item: Bullet) { Bullet._frees.push(item) }

    private _events: any[];
    addPosEvent(name: string, val: number, props, dir) {
        this._events = this._events || [];
        this._events.push({ key: `${name}-${val}`, props: props, dir: dir });
    }

    updateFunc() {
        super.updateFunc();
        if (!this._events) return;
        for (let i = 0; i < this._events.length; i++) {
            const event = this._events[i];
            const key = event.key;
            const props = event.props;
            const dir = event.dir;
            const name = key.split('-')[0];
            const val = parseInt(key.split('-')[1]);
            const c1 = this[name] > val && dir == 1;
            const c2 = this[name] < val && dir == -1;
            if (c1 || c2) {
                this._events.splice(i, 1);
                i--;
                if (props.hasOwnProperty('gravityY'))
                    this.gravityY = props.gravityY;
                if (props.hasOwnProperty('collideWorldBounds'))
                    this.collideWorldBounds = props.collideWorldBounds;
                if (props.hasOwnProperty('velocityX'))
                    this.velocityX = props.velocityX;
                if (props.hasOwnProperty('velocityY'))
                    this.velocityY = props.velocityY;
            }
        }
    }
}