export default class Body extends egret.Sprite {
    anY = 0;
    anX = 0;
    private _rect: egret.Rectangle;
    private _view: egret.DisplayObject;
    private _counter = 0;

    set rect(val: egret.Rectangle) {
        this._rect = val;
        this.anX = -this._rect.width / 2;
        this.anY = -this._rect.height / 2;
    }
    get rect() { return this._rect }


    private _gravityY = 0;
    private _gravityX = 0;
    /**
     * 每帧移动的px数
     */
    private _velocityY = 0;
    private _velocityX = 0;
    private _bounceY = 0;
    private _bounceX = 0;

    updateFunc(): any {
        this._counter++;
        this._velocityY += this._gravityY;
        this._velocityX += this._gravityX;
        this.y += this._velocityY;
        this.x += this._velocityX;
        if (this._view) this._view.rotation = this._counter * .7 * this._rotationSpeed;
    }

    private _rotationSpeed = 0;

    set rotationSpeed(val: number) {
        this._rotationSpeed = val;
    }

    set gravity(val: number) {
        this._gravityX = val;
        this._gravityY = val;
    }

    set gravityY(val: number) {
        this._gravityY = val;
    }

    set velocityY(val: number) {
        this._velocityY = val;
    }

    set velocity(val: number) {
        this._velocityY = val;
        this._velocityX = val;
    }

    set velocityX(val: number) {
        this._velocityX = val;
    }

    get velocityX() {
        return this._velocityX;
    }

    get velocityY() {
        return this._velocityY;
    }

    set bounceY(val: number) {
        this._bounceY = val;
    }

    set bounceX(val: number) {
        this._bounceX = val;
    }

    set bounce(val: number) {
        this._bounceX = val;
        this._bounceY = val;
    }

    get bounceY() {
        return this._bounceY;
    }

    get bounceX() {
        return this._bounceX;
    }

    set view(val) {
        this._view = val;
    }

    private _collideWorldBounds: boolean;
    set collideWorldBounds(val: boolean) { this._collideWorldBounds = val; }
    get collideWorldBounds() { return this._collideWorldBounds }

    handleCollide(eventName, data?: Body) {

    }
}