import HDGameSubmitAfterDostart from "../../libs/new_tw/ctrls/HDGameSubmitAfterDostart";
import customIsWinning from "../../libs/new_tw/datas/CustomIsWinning";
import Loading from "../../libs/new_wx/components/Loading";
import StartSceneBase from "../../libs/new_wx/components/StartSceneBase";
import PanelCtrl from "../../libs/new_wx/ctrls/panelCtrl";
import showAlertPanel from "../../libs/new_wx/ctrls/showAlertPanel";
import { ModuleTypes } from "../../libs/new_wx/types/sceneTypes";
import { ItemTypes, randomItem } from "./ItemTypes";
import MovieClip from "./MovieClip";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Cookie } from "../../libs/tw/util/Cookie";
import hdGameDoDojoin from "../../libs/new_tw/ctrls/hdGameDoDojoin";
import doJoin from "../../libs/new_tw/ctrls/doJoin";
// tslint:disable
export default class StartScene extends StartSceneBase {
  bullet: eui.Image;
  shotter: eui.Image;

  


  boom: MovieClip;
  startX = 375;
  startY = 1234;
  padding = 40;
  padding2 = 15;
  target1: any = {};
  target2: any = {};
  target3: any = {};
  target;
  p0;
  p1;
  p2;
  userInfo;

  recordBtn;
  ruleBtn;

//   logo_guohua;
//   logo_fd_beijing;
//   logo_fd_zhejiang;
  
  currentList = [ItemTypes.box, ItemTypes.money, ItemTypes.gold];
  async start(data?) {
    super.start();
    this.prepareScene();
    this["wapper"].y = this.stage.stageHeight - 1624;
    this.target1.x = 66.56 + 75.5;
    this.target1.y = 910 + 76;
    this.target2.x = 315.56 + 75.5;
    this.target2.y = 910 + 76;
    this.target3.x = 563.56 + 75.5;
    this.target3.y = 910 + 76;
    this.prepareShot();
    this.playHand();
    this.playLogoAni();
    this.updateItems();
    this.getUserInfo();
    console.log(this.currentList);

    window["getUserInfo"]((res)=>{
      this.addLogo(res.data.companyActivityLogo);
    })

    RES.loadGroup('prize');

    if(DataManager.ins.customCfgData.preview){
      this.recordBtn.visible = false;
      return;
    }
    
  }

  addLogo(url){
    if(!url){
        console.log("没有logo图片链接");
        return;
    }
    console.log("logo = " + url);
    let imgLoader = new egret.ImageLoader();
    imgLoader.crossOrigin = "anonymous";// 跨域请求
    imgLoader.load(url);// 去除链接中的转义字符‘\’        
    imgLoader.once(egret.Event.COMPLETE, function(evt: egret.Event) {
        if (evt.currentTarget.data) {
            egret.log("加载logo成功!");
            let texture = new egret.Texture();
            texture.bitmapData = evt.currentTarget.data;
            let bitmap = new egret.Bitmap(texture);
            bitmap.x = 30;
            bitmap.y = 0;
            // this["wapper"].addChild(bitmap);
            // this.addChild(bitmap);
            var logoWidth = window["logo_width"];
            logoWidth = logoWidth || 200;
            if(bitmap.width > logoWidth){
              bitmap.scaleX = logoWidth / bitmap.width;
              bitmap.scaleY = bitmap.scaleX;
              console.log(bitmap.scaleX);
            }
            console.log(bitmap.width + " x " + bitmap.height);
            this.addChildAt(bitmap, this.numChildren - 1);
            egret.log(this);
            
        }
    }, this);
  }

  prepareShot() {
    this.bullet.visible = false;
    const time = 500 * 1.5;
    this.shotter.rotation = 0;
    this.bullet.scaleX = this.bullet.scaleY = 1;
    egret.Tween.get(this.shotter, { loop: true })
      .to({ rotation: this.padding }, time)
      .to({ rotation: -this.padding }, time * 2)
      .to({ rotation: 0 }, time);
  }

  async waitForBullet() {
    this.stopHandPlay();
    const r = (this.shotter.rotation / 180) * Math.PI;
    const px = 149 * Math.sin(r);
    const py = 149 * Math.cos(r);
    this.bullet.x = 377 + px;
    this.bullet.y = 1474 - py;
    this.bullet.visible = true;

    if (this.boom) {
      const boompx = 300 * Math.sin(r);
      const boompy = 300 * Math.cos(r);
      this.boom.x = 377 + boompx;
      this.boom.y = 1474 - boompy;
      this.boom.visible = true;
      this.boom.play();
    }

    let p2 = this.target2;
    let p1;
    if (this.shotter.rotation > this.padding2) {
      p2 = this.target3;
      p1 = { x: 603, y: 813 - 100 };
      this.target = 2;
    } else if (this.shotter.rotation < -this.padding2) {
      p2 = this.target1;
      p1 = { x: 750 - 603, y: 813 - 100 };
      this.target = 0;
    } else {
      p1 = { x: 750 / 2, y: 608 };
      this.target = 1;
      // if (this.shotter.rotation > 0)
      //     p1 = { x: 750 / 2+150, y: 608 };
      // else
      //     p1 = { x: 750 / 2, y: 608 };
    }

    const p0 = new egret.Point(this.bullet.x, this.bullet.y);
    this.p0 = p0;
    this.p1 = p1;
    this.p2 = p2;

    return new Promise(r => {
      console.log("炮弹开始运动");
      egret.Tween.get(this)
        .to({ factor: 1 }, 700)
        .call(() => {
          r();
        });
    });
  }

  set factor(value: number) {
    // console.log(`炮弹运动中${value}`);
    // this.bullet.scaleX = this.bullet.scaleY = (1 - value) * .5 + .5;
    const { p0, p1, p2 } = this;
    this.bullet.x =
      (1 - value) * (1 - value) * p0.x +
      2 * value * (1 - value) * p1.x +
      value * value * p2.x;
    this.bullet.y =
      (1 - value) * (1 - value) * p0.y +
      2 * value * (1 - value) * p1.y +
      value * value * p2.y;
  }

  get factor(): number {
    return 0;
  }

  async onTap_joinBtn(e?: egret.Event) {
    if (window.location.href.match(/preview=1/)) {
      window.alert = function(name){
        var iframe = document.createElement("IFRAME");
        iframe.style.display="none";
        document.documentElement.appendChild(iframe);
        window.frames[0].window.alert(name);
        iframe.parentNode.removeChild(iframe)
      }
      window.confirm = function (message) {
        var iframe = document.createElement("IFRAME");
        iframe.style.display = "none";
        iframe.setAttribute("src", 'data:text/plain,');
        document.documentElement.appendChild(iframe);
        var alertFrame = window.frames[0];
        var result = alertFrame.window.confirm(message);
        iframe.parentNode.removeChild(iframe);
        return result;
      }
      window.alert('试玩不支持抽奖，分享后即可抽奖')
      return
    }
    this.joinBtn.touchEnabled = false;
    egret.Tween.removeTweens(this.shotter);
    this.playShotAni();
    await this.waitForBullet();
    await this.waitForShotted();
    Loading.instace.show();
    //hdGameDoDojoin
    // doJoin(async success =>{
    //   Loading.instace.hide();
    //   this.joinBtn.touchEnabled = true;
    //   this.prepareShot();
    //   this.playHand();
    //   this.updateCountTxt();
    //   if (!success) {
    //     return;
    //   }
    //   if (customIsWinning()) {
    //     PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL);
    //   } else {
    //     showAlertPanel("手气不佳,未中奖");
    //   }
    //   this.addNewItem();
    //   this.updateItems();
    // })
    HDGameSubmitAfterDostart(async success => {
      Loading.instace.hide();
      this.joinBtn.touchEnabled = true;
      this.prepareShot();
      this.playHand();
      this.updateCountTxt();
      if (!success) {
        return;
      } //扣分异常、或者轮询超时、或者提交分数异常
      if (customIsWinning()) {
        PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL);
      } else {
        showAlertPanel("手气不佳,未中奖");
      }
      this.addNewItem();
      this.updateItems();
    }, this.getscore());
  }

  getscore() {
    const type = this.currentList[this.target];
    if (type == ItemTypes.box) return 10;
    if (type == ItemTypes.egg) return 20;
    if (type == ItemTypes.gift) return 30;
    if (type == ItemTypes.gold) return 40;
    if (type == ItemTypes.money) return 50;
    return 10;
  }

  waitForShotted() {
    this.bullet.visible = false;
    return new Promise(r => {
      const key = `${this.currentList[this.target]}_${this.target}`;
      //f_circle
      //f_tuan1 2 3
      //f_10_1 2 3 4
      //f_s1 2
      this["f_ani"].x = 143;
      if (this.target == 1) this["f_ani"].x = 143 + 249;
      if (this.target == 2) this["f_ani"].x = 143 + 249 + 248;
      egret.Tween.get(this["f_circle"])
        .set({ scaleX: 0, scaleY: 0, alpha: 1 })
        .to({ scaleX: 0.6, scaleY: 0.6, alpha: 1 }, (1 / 6) * 1000)
        .to({ scaleX: 1, scaleY: 1, alpha: 0 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_tuan1"])
        .set({ x: 0, y: 0, alpha: 1 })
        .to({ x: -84 / 2, y: 20 / 2 }, (1 / 6) * 1000)
        .to({ x: -84, y: 20, alpha: 0 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_tuan2"])
        .set({ x: 0, y: 0, alpha: 1 })
        .to({ x: 76 / 2, y: 38 / 2 }, (1 / 6) * 1000)
        .to({ x: 76, y: 38, alpha: 0 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_tuan3"])
        .set({ x: 0, y: 0, alpha: 1 })
        .to({ y: -67 / 2 }, (1 / 6) * 1000)
        .to({ y: -67, alpha: 0 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_s1"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: 36 / 2, y: -94 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: 36, y: -94, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_s2"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: 92 / 2, y: 22 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: 92, y: 22, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_10_1"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: -70 / 2, y: -70 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: -70, y: -70, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_10_2"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: 44 / 2, y: 82 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: 44, y: 82, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_10_3"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: -64 / 2, y: 78 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: -64, y: 78, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this["f_10_4"])
        .set({ x: 0, y: 0, alpha: 1, rotation: 0 })
        .to({ x: -103 / 2, rotation: 30 }, (1 / 6) * 1000)
        .to({ x: -103, alpha: 0, rotation: 60 }, (1 / 6) * 1000);
      egret.Tween.get(this[key])
        .to({ scaleX: 1.2, scaleY: 0.8 }, (5 / 30) * 1000)
        .to({ scaleX: 0.9, scaleY: 1.1 }, (5 / 30) * 1000)
        .to({ scaleX: 1, scaleY: 1 }, (5 / 30) * 1000)
        .call(r);
    });
  }

  playShotAni() {
    egret.Tween.get(this.shotter)
      .to({ scaleX: 1.1, scaleY: 0.8 }, (3 / 30) * 1000)
      .to({ scaleX: 0.9, scaleY: 1.1 }, (3 / 30) * 1000)
      .to({ scaleX: 1.05, scaleY: 0.95 }, (3 / 30) * 1000)
      .to({ scaleX: 1, scaleY: 1 }, (2 / 30) * 1000);
    egret.Tween.get(this["shotter_p3"])
      .wait((6 / 30) * 1000)
      .to({ y: this["shotter_p3"].y + 10 }, (3 / 30) * 1000)
      .to({ y: this["shotter_p3"].y }, (2 / 30) * 1000);
    egret.Tween.get(this["shotter_p1"])
      .wait((6 / 30) * 1000)
      .to({ y: this["shotter_p1"].y + 10 }, (3 / 30) * 1000)
      .to({ y: this["shotter_p1"].y }, (2 / 30) * 1000);
    egret.Tween.get(this["shotter_p2"])
      .wait((6 / 30) * 1000)
      .to({ y: this["shotter_p2"].y + 10 }, (3 / 30) * 1000)
      .to({ y: this["shotter_p2"].y }, (2 / 30) * 1000);
  }

  prepareScene() {
    RES.getResAsync(
      "sail_json",
      t => {
        const s1 = this.createSailMovieClip(t);
        const s2 = this.createSailMovieClip(t);
        const s3 = this.createSailMovieClip(t);
        this["group0"].addChildAt(s1, 0);
        this["group1"].addChildAt(s2, 0);
        this["group2"].addChildAt(s3, 0);
      },
      this
    );

    RES.getResAsync(
      "boom_json",
      t => {
        const boom = this.createBoomMovieClip(t);
        this.boom = boom;
        this["wapper"].addChild(boom);
        this.boom.visible = false;
      },
      this
    );

    const y = this["group0"].y;
    const strength = 10;
    egret.Tween.get(this["group0"], { loop: true })
      .wait(1)
      .to({ y: y + strength }, 1000, egret.Ease.quadInOut)
      .to({ y: y }, 1000, egret.Ease.quadInOut);
    egret.Tween.get(this["group1"], { loop: true })
      .wait(200)
      .to({ y: y + strength }, 1000, egret.Ease.quadInOut)
      .to({ y: y }, 1000, egret.Ease.quadInOut);
    egret.Tween.get(this["group2"], { loop: true })
      .wait(400)
      .to({ y: y + strength }, 1000, egret.Ease.quadInOut)
      .to({ y: y }, 1000, egret.Ease.quadInOut);
  }

  createSailMovieClip(spritesheet) {
    const list = [];
    for (let i = 20; i <= 50; i++) {
      list.push("帆_000" + i);
    }

    const movieclip = new MovieClip({
      spritesheet: spritesheet,
      frameInterval: 2,
      frames: list,
      position: [34, -67],
      scale: 1,
      anchor: [346 / 750, 844 / 1624]
    });
    return movieclip;
  }

  createBoomMovieClip(spritesheet) {
    const list = [];
    for (let i = 0; i <= 8; i++) {
      list.push("爆炸_0000" + i);
    }

    const movieclip = new MovieClip({
      spritesheet: spritesheet,
      frameInterval: 2,
      frames: list,
      position: [0, 0],
      scale: 1,
      loop: false,
      anchor: [1 / 2, 1154 / 1624]
    });
    return movieclip;
  }

  lightcircle: eui.Image;
  hand: eui.Image;
  playHand() {
    egret.Tween.removeTweens(this.hand);
    egret.Tween.removeTweens(this.lightcircle);
    this.hand.alpha = 1;
    this.hand.visible = true;
    this.hand.scaleX = this.hand.scaleY = 1;
    this.lightcircle.alpha = 1;
    this.lightcircle.visible = true;
    this.lightcircle.scaleX = this.lightcircle.scaleY = 1;
    const tw1 = egret.Tween.get(this.hand, { loop: !0 });
    tw1
      .set({ alpha: 1 })
      .to({ scaleX: 0.8, scaleY: 0.8 }, 1000 / 6)
      .to({ scaleX: 1, scaleY: 1 }, 1000 / 6)
      .to({ scaleX: 0.8, scaleY: 0.8 }, 1000 / 6)
      .to({ scaleX: 1, scaleY: 1 }, 1000 / 6)
      .to({ alpha: 0 }, 100)
      .wait(1000);

    const tw2 = egret.Tween.get(this.lightcircle, { loop: !0 });
    tw2
      .wait(100)
      .to({ scaleX: 2, scaleY: 2, alpha: 0 }, (1000 / 6) * 2)
      .set({ alpha: 1, scaleX: 1, scaleY: 1 })
      .to({ scaleX: 2, scaleY: 2, alpha: 0 }, (1000 / 6) * 2)
      .wait(100)
      .wait(1000 - 100);
  }

  stopHandPlay() {
    egret.Tween.removeTweens(this.hand);
    egret.Tween.removeTweens(this.lightcircle);
    this.hand.visible = false;
    this.lightcircle.visible = false;
  }

  logo_title: eui.Image;
  logo_wave: eui.Image;
  logo_shotter: eui.Image;
  leaf1: eui.Image;
  leaf2: eui.Image;
  wavebg: eui.Image;
  fishbg1: eui.Image;
  fishbg2: eui.Image;
  fishbg3: eui.Image;
  fishbg4: eui.Image;
  async playLogoAni() {
    this.logo_title.scaleX = 0;
    this.logo_wave.alpha = 0;
    this.logo_shotter.alpha = 0;
    // await wait(500);
    egret.Tween.get(this.logo_title).to(
      { scaleX: 1 },
      500,
      egret.Ease.getBackOut(3)
    );
    const y = this.logo_wave.y;
    egret.Tween.get(this.logo_wave)
      .wait(200)
      .set({ y: y + 20, alpha: 1 })
      .to({ y: y }, 300, egret.Ease.getBackOut(1));
    egret.Tween.get(this.logo_shotter)
      .wait(500)
      .set({ alpha: 1, y: 550, rotation: 30 })
      .to({ y: 545, rotation: 0 }, 300, egret.Ease.getBackOut(3));
    egret.Tween.get(this.leaf1, { loop: true })
      .to({ rotation: 10 }, 1000, egret.Ease.quadInOut)
      .to({ rotation: 0 }, 1000, egret.Ease.quadInOut);
    egret.Tween.get(this.leaf2, { loop: true })
      .to({ rotation: -10 }, 1000, egret.Ease.quadInOut)
      .to({ rotation: 0 }, 1000, egret.Ease.quadInOut);
    egret.Tween.get(this.wavebg, { loop: true })
      .to({ scaleX: 1.1, scaleY: 1.1 }, 3000)
      .to({ scaleX: 1, scaleY: 1 }, 3000);
    egret.Tween.get(this.fishbg1, { loop: true })
      .to({ x: this.fishbg1.x - 16, y: this.fishbg1.y + 3 }, 3000)
      .to({ x: this.fishbg1.x, y: this.fishbg1.y }, 3000);
    egret.Tween.get(this.fishbg2, { loop: true })
      .to({ x: this.fishbg2.x + 8, y: this.fishbg2.y + 10 }, 3000)
      .to({ x: this.fishbg2.x, y: this.fishbg2.y }, 3000);
    egret.Tween.get(this.fishbg3, { loop: true })
      .to({ x: this.fishbg3.x + 14, y: this.fishbg3.y + 8 }, 3000)
      .to({ x: this.fishbg3.x, y: this.fishbg3.y }, 3000);
    egret.Tween.get(this.fishbg4, { loop: true })
      .to({ x: this.fishbg4.x + 16, y: this.fishbg4.y - 8 }, 3000)
      .to({ x: this.fishbg4.x, y: this.fishbg4.y }, 3000);
  }

  addNewItem() {
    const newitem = randomItem(this.currentList);
    this.currentList[this.target] = newitem;
  }

  updateItem(targret, type: ItemTypes) {
    this[`box_${targret}`].visible = false;
    this[`egg_${targret}`].visible = false;
    this[`gift_${targret}`].visible = false;
    this[`money_${targret}`].visible = false;
    this[`gold_${targret}`].visible = false;

    this[`${type}_${targret}`].visible = true;
  }

  updateItems() {
    this.updateItem(0, this.currentList[0]);
    this.updateItem(1, this.currentList[1]);
    this.updateItem(2, this.currentList[2]);
  }

  destroy() {
    super.destroy();
  }

  getUserInfo() {
    let dcustom = Cookie.getCookie('dcustom');
    console.log("getUserInfo dcustom");
    console.log(dcustom);
    let Info = decodeURIComponent(dcustom).replace('{','').replace('}','').split(',');

    this.userInfo = {}
    Info.map(item=>{
        let newInfo = item.split('=');
        // var o = new Object();
        window.localStorage.setItem(newInfo[0],newInfo[1])
        this.userInfo[newInfo.shift()] = newInfo.join('=')
    })

    console.log("userInfo");
    console.log(this.userInfo);

    /*
    if(this.userInfo.visitId){
        console.log(this.userInfo)
        setInterval(()=>{
          this.getTime()
        },5000)
    }
    */
    if(this.userInfo.forward == 1){
      this.shareTips.visible = true
    }
    // console.log(Info1)
    return this.userInfo
  }

  getTime(){
    let url = window.location.href;
    let host= '';
    if(url.indexOf('test')>-1){
      host = 'https://kjj.m.duibatest.com.cn'
    }else if(url.indexOf('dev')>-1){
      host = 'http://kjj.m.duibadev.com.cn'
    }else {
      host = 'https://kjj.m.duiba.com.cn'
    }
    const net = {
        name: "getTime",
        uri: host + '/kjy/mp/content/updateDuration',
        type: 'get',
        dataType: 'json',
        actType:'kjj',
        kjjTku:this.userInfo.tku,
        param: {
            visitId:this.userInfo.visitId,
        },
        callback:(success)=>{
            if(!success){
                return;
            }
        }
    };
    NetManager.ins.send(net)
}
}
