  export class Cookie{
    /**
     * 获取cookie的值
     * @param {*} cookieName
     */
    public static getCookie(cookieName) {
        const strCookie = document.cookie;
        const arrCookie = strCookie.split("; ");
        for (let i = 0; i < arrCookie.length; i++) {
            let arr = arrCookie[i].split("=");
            if (cookieName == arr[0]) {
                return arr[1];
            }
        }
        return "";
    }

    public static getItem(sKey) {
        return decodeURIComponent(document.cookie.replace(new RegExp("(?:(?:^|.*;)\\s*" + encodeURIComponent(sKey).replace(/[-.+*]/g, "\\$&") + "\\s*\\=\\s*([^;]*).*$)|^.*$"), "$1")) || null;
    }

    public static getDcustomCookie (dcustomKey) {
        let dcustom = Cookie.getItem('dcustom');
        if(!dcustom){
          return null;
        }
        let dcustom1 = dcustom.split('{')[1].split('}')[0];
        let dcustom2 = dcustom1.split(',').filter(it => {
          return it.indexOf(dcustomKey) > -1
        });
        if (dcustom2.length) {
          return dcustom2[0].split('=')[1];
        } else {
          return null;
        }
    }

    public static setItem(sKey, sValue, vEnd, sPath, sDomain, bSecure) {
        if (!sKey || /^(?:expires|max\-age|path|domain|secure)$/i.test(sKey)) { return false; }
        var sExpires = "";
        if (vEnd) {
          switch (vEnd.constructor) {
            case Number:
              sExpires = vEnd === Infinity ? "; expires=Fri, 31 Dec 9999 23:59:59 GMT" : "; max-age=" + vEnd;
              break;
            case String:
              sExpires = "; expires=" + vEnd;
              break;
            case Date:
              sExpires = "; expires=" + vEnd.toUTCString();
              break;
          }
        }
        document.cookie = encodeURIComponent(sKey) + "=" + encodeURIComponent(sValue) + sExpires + (sDomain ? "; domain=" + sDomain : "") + (sPath ? "; path=" + sPath : "") + (bSecure ? "; secure" : "");
        return true;
    }
}
