import { DataManager } from './../../manager/DataManager';
import { NetManager } from "../../manager/NetManager";
import { ActivityModel } from "../common/ActivityModel";
import { IDynamicData } from '../../data/game/datapash/IDynamicData';

export class GameModel extends ActivityModel {
    /**
     * 获取规则数据
     */
    public getRule(callback: Function): void {
        if (DataManager.ins.getRuleData) {
            callback(true);
        } else {
            NetManager.ins.getRule(callback);
        }
    }

    /**
     * 获取活动奖品数据
     */
    public getOptions(callback: Function): void {
        if (DataManager.ins.getOptionsData) {
            callback(true);
        } else {
            NetManager.ins.getOptions(callback);
        }
    }

    /**
     * 开始游戏
     * @param callback 
     * @param isAgain
     * @param credits 
     * @param customizedType 
     */
    public doStart(callback: Function, isAgain = false, credits?: number, customizedType?: number): void {
        if(window['requirelogin']) {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doStart((success: boolean) => {
            if(success) {
                this.getStartOrderStatus(callback, customizedType);
            } else {
                callback(success);
            }
        },
        isAgain,
        credits,
        customizedType);
    }

    /**
     * 查询订单结果
     * @param callback 
     * @param ticketId 
     * @param customizedType
     */
    private getStartOrderStatus(callback: Function, customizedType?: number): void {
        NetManager.ins.getStartStatus(
            callback,
            DataManager.ins.doStartData.ticketId,
            () => { return DataManager.ins.getStartStatusData.code != 1; },
            5,
            customizedType);
    }

    // /**
    //  * 获取用户数据
    //  * @param callback 
    //  */
    // public getInfo(callback: Function): void {
    //     NetManager.ins.getInfo(callback);
    // }

    /**
     * 获取夏日活动用户数据
     * @param callback 
     */
    public getSummerInfo(callback: Function, rankBaseConfigId:number): void {
        NetManager.ins.getSummerInfo(callback, rankBaseConfigId);
    }

    /**
     * 阶段数据提交
     * @param callback 
     * @param dynamicStr 数据
     */
    protected datapashData(callback: Function, dynamicStr: string): void {
        NetManager.ins.datapash(null, DataManager.ins.doStartData.ticketId, dynamicStr);
    }

    /**
     * 猜扑克
     * @param callback 
     * @param plugId 插件ID
     * @param ruleId 集卡规则ID
     * @param betting 0大1小2红3黑 
     */
    public guessPoker(callback: Function, plugId: number, ruleId: number, betting: number): void {
        NetManager.ins.guessPoker(callback, plugId, DataManager.ins.doStartData.ticketId, ruleId, betting)
    }
    /**
     * 提交游戏成绩
     * @param callback 
     * @param score 得分
     * @param allDynamics 防作弊数据
     * @param checkScore  是否校验得分
     * @param customizedType 定制类型 1推币机    
     */
    protected gameSubmitData(callback: Function, score: number, allDynamics: IDynamicData[][], checkScore?: boolean, customizedType?: number): void {
        NetManager.ins.gameSubmit(
            (success: boolean) => { 
                if(success) {
                    this.getSubmitResult(callback, DataManager.ins.gameSubmitData.orderId); 
                } else {
                    callback(success);
                }
            },
            DataManager.ins.doStartData.ticketId,
            score,
            '[]',
            DataManager.ins.doStartData.submitToken,
            JSON.stringify(allDynamics),
            checkScore,
            customizedType);
    }

    /**
     * 查询提交结果
     * @param callback 
     * @param orderId 
     */
    private getSubmitResult(callback: Function, orderId: number): void {
        NetManager.ins.getSubmitResult(callback, orderId, () => {
            return DataManager.ins.gameGetSubmitResultData.flag;
        });
    }

    /**
     * 获取实时排行榜数据
     * @param callback 
     * @param type 0总排行榜 1今日排行榜 2 多游戏总排行榜 3 昨日排行榜
     * @param count 
     */
    public realtimerank(callback: Function, type = 0, count = 30): void {
        NetManager.ins.realtimerank(callback, type, count)
    }
}