import { ActivityModel } from './ActivityModel';
import { NetManager } from '../../manager/NetManager';
import { DataManager } from '../../manager/DataManager';
/**
 * 自定义活动工具业务模型
 */
export class CustomModel extends ActivityModel {
    /**
     * 抽奖
     * @param callback
     * @param nextStep 下一步做什么，轮询结果或者前置开奖等
     */
    public customDoJoin(callback: Function, nextStep: Function, collectRuleId?: number): void {
        if (window['uid'] == 'not_login') {
            window['requirelogin']();
            return;
        }
        NetManager.ins.doJoin((success: boolean) => {
            if (nextStep && success) {
                nextStep(callback);
            } else {
                callback(success);
            }
        }, collectRuleId);
    }

    /**
     * 获取活动工具抽奖结果
     * @param callback 
     */
    public getCustomOrderStatus(callback: Function): void {
        NetManager.ins.getCustomOrderStatus(callback, DataManager.ins.doJoinData.orderId, () => {
            return DataManager.ins.getCustomOrderStatusData.result == 0;
        });
    }
    /**
     * 获取前置开奖信息
     * @param callback 
     */
    public getOrderInfo(callback: Function): void {
        NetManager.ins.getOrderInfo(callback, DataManager.ins.doJoinData.orderId);
    }

    /**
     * 前置抽奖提交
     * @param callback 
     */
    public beforSubmit(callback: Function): void {
        NetManager.ins.beforSubmit((success: boolean) => {
            if (success) {
                this.getCustomOrderStatus(callback);
            } else {
                callback(success);
            }
        },
            DataManager.ins.doJoinData.orderId,
            DataManager.ins.getOrderInfoData.facePrice);
    }
    /**
     * 闯关游戏提交
     * @param callback 
     */
    public throughSubmit(callback: Function): void {
        NetManager.ins.throughSubmit(callback, DataManager.ins.doJoinData.orderId);
    }

    /**
     * 活动工具是否中奖
     */
    public get customIsWinning(): boolean {
        return DataManager.ins.getCustomOrderStatusData.lottery ? true : false;
    }
}