export default class GuiderView{

    arr:Array<eui.Image>;
    cir1:eui.Rect;
    cir2:eui.Rect;
    idx:number = 0;
    frame:number = 0;

    public constructor(hand1:eui.Image, hand2:eui.Image, cir1:eui.Rect, cir2:eui.Rect){
        this.arr = new Array();
        this.arr.push(hand1);
        this.arr.push(hand2);
        this.cir1 = cir1;
        this.cir2 = cir2;
        hand1.touchEnabled = false;
        hand2.touchEnabled = false;
        this.cir1.touchEnabled = false;
        this.cir2.touchEnabled = false;
        this.effectPlay();
    }

    public update(){
        if(++this.frame > 18){
            this.frame = 0;
            if(++this.idx >= this.arr.length){
                this.idx = 0;
            }
            this.handPlay();
        }
    }

    handPlay(){
        for(var i = 0; i < this.arr.length; i++){
            if(i == this.idx){
                this.arr[i].visible = true;
            }
            else{
                this.arr[i].visible = false;
            }
        }
    }

    effectPlay(){

        this.cir1.scaleX = 0.4;
        this.cir1.scaleY = 0.4;
        this.cir2.scaleX = 0.4;
        this.cir2.scaleY = 0.4;

        egret.Tween.get(this.cir1, {loop: true})
        .to({scaleX: 2, scaleY: 2, alpha: 0}, 300)

        egret.Tween.get(this.cir2, {loop: true})
        .wait(150)
        .to({scaleX: 2, scaleY: 2, alpha: 0}, 300)
    }

}