import getIsIOS from "../../new_tc/getIsIOS";
import doStart from "../../new_tw/ctrls/doStart";
import getCountTxt from "../../new_tw/datas/getCountTxt";
import getStartBtnEnable from "../../new_tw/datas/getStartBtnEnable";
import { DataManager } from "../../tw/manager/DataManager";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import Scene from "./Scene";
import doJoin from "../../new_tw/ctrls/doJoin";
import getJoinCountTxt from "../../new_tw/datas/getJoinCountTxt";
import wait from "../../new_tc/wait";
import { TwFun } from "../../tw/util/TwFun";
import showAlertPanel from "../ctrls/showAlertPanel";

export default class StartSceneBase extends Scene {
  ruleBtn: eui.Button;
  htmlRuleBtn: eui.Button;
  optionBtn: eui.Button;
  recordBtn: eui.Button;
  joinBtn: eui.Button;
  rankBtn: eui.Button;
  public shareTips: eui.Group;
  countTxt: eui.Label;
  exemptionTxt: eui.Label;
  _timer: egret.Timer;

  async start(data?) {
    this.joinBtn.visible = false;
    this.updateGetInfoView();
    this.updateExemptionTxt();
    super.start();
  }
  private colorMatrix = [
    0.3,
    0.6,
    0,
    0,
    0,
    0.3,
    0.6,
    0,
    0,
    0,
    0.3,
    0.6,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0
  ];

  private colorFlilter = new egret.ColorMatrixFilter(this.colorMatrix);
  private updateGetInfoView() {
    if (DataManager.ins.ajaxElementData) {
      this.updateJoinBtnStatus();
      this.updateCountTxt();
    } else {
      DataManager.ins.once("dataUpdate", this.updateGetInfoView, this);
    }
  }

  async updateJoinBtnStatus() {
    if (this.joinBtn) {
      this.joinBtn.visible = true;
    }
  }

  updateCountTxt() {
    if (this.countTxt) {
      // this.countTxt.text = getJoinCountTxt();
      this.countTxt.text = "今日炮弹数：" + DataManager.ins.ajaxElementData.element.freeLimit;

      //次数为0是按钮警用
      if (DataManager.ins.ajaxElementData.element.freeLimit == 0) {
        this.joinBtn.enabled = false;
        this.joinBtn.filters = [this.colorFlilter];
      }
    }
  }

  updateExemptionTxt() {
    if (this.exemptionTxt) {
      if (getIsIOS()) {
        this.exemptionTxt.visible = true;
      } else {
        this.exemptionTxt.visible = false;
      }
    }
  }

  initEvents() {
    if (this.ruleBtn)
      this.ruleBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_ruleBtn,
        this
      );
    if (this.htmlRuleBtn)
      this.htmlRuleBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_htmlRuleBtn,
        this
      );
    if (this.optionBtn)
      this.optionBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_optionBtn,
        this
      );
    if (this.recordBtn)
      this.recordBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_recordBtn,
        this
      );
    if (this.joinBtn)
      this.joinBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_joinBtn,
        this
      );
    if (this.rankBtn)
      this.rankBtn.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_rankBtn,
        this
      );
    if (this.shareTips)
      this.shareTips.addEventListener(
        egret.TouchEvent.TOUCH_TAP,
        this.onTap_shareTips,
        this
      );
  }

  onTap_ruleBtn(e: egret.Event) {
    PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);
  }
  onTap_htmlRuleBtn(e: egret.Event) {
    PanelCtrl.instance.show(ModuleTypes.HTML_RULE_PANEL);
  }

  onTap_optionBtn(e: egret.Event) {
    PanelCtrl.instance.show(ModuleTypes.OPTIONS_PANEL);
  }

  onTap_recordBtn(e: egret.Event) {
    console.log("跳转定制兑换记录页");
    // window.location.href = TwFun.getRecordUrl('00');
    let activity = localStorage.getItem("activityId");
     // let uid = localStorage.getItem('visitId')
    window.location.href =
      window["gloal"].recordUrl +
      `&uid=${CFG.uid}&activityId=${activity}` +
      "&origins=" +
      CFG.actId +
      "00";
  }

  async onTap_joinBtn(e?: egret.Event) {
    // doJoin(async () => {
    //     this.updateCountTxt();
    // });
  }

  onTap_rankBtn(e: egret.Event) {
    PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
  }
  onTap_shareTips(e: egret.Event) {
    this.shareTips.visible = false
  }

  get skinKey() {
    return "Start";
  }
}
