import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import { HtmlTextParser } from "../HtmlTextParser";
import Panel from "./Panel";
import { Cookie } from "../../tw/util/Cookie";

export default class RulePanel extends Panel {
  // public labContent: eui.Label;
  // public scroller: eui.Scroller;

  public ruleBg: eui.Image;
  public closeBtn: eui.Button;
  public scroller: eui.Scroller;
  public group: eui.Group;
  public labContent: eui.Label;
  public ruleText1: eui.Label;
  public ruleText2: eui.Label;
  public ruleText3: eui.Label;

  start() {
    if (!DataManager.ins.ajaxElementData)
      NetManager.ins.ajaxElement(() => {
        this.addRule();
      });
    else this.addRule();
  }

//   group: eui.Group;
  private addRule() {
    // const text = DataManager.ins.ajaxElementData.rule;
    // this.labContent.textFlow = new HtmlTextParser().parser(text);
    const {ruleInfo} = window["gloal"];
    // console.log(window["gloal"])
    const text1 = window["gloal"].ruleInfo.text1;
    const text2 = window["gloal"].ruleInfo.text2;
    const text3 = window["gloal"].ruleInfo.text3;
    let pname = Cookie.getDcustomCookie("pname");
    let newStr = pname ? text2.replace("精美奖品", pname) : text2;
    this.ruleText1.textFlow = new HtmlTextParser().parser(text1);
    this.ruleText2.textFlow = new HtmlTextParser().parser(newStr);
    this.ruleText3.textFlow = new HtmlTextParser().parser(text3);
  }

  get skinKey() {
    return "Rule";
  }
}
