import showCustomLog from "../../new_tw/ctrls/showCustomLog";
import { LotteryType } from "../../tw/enum/LotteryType";
import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import { HtmlTextParser } from "../HtmlTextParser";
import showAlertPanel from "../ctrls/showAlertPanel";
import Panel from "./Panel";

export default class PrizePanel extends Panel {

    public objbg:eui.Image;
    public objlihua:eui.Image;
    public tryGroup:eui.Group;
    public objname:eui.Label;

    start(data) {
        console.log("显示弹窗");
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        this.data = lottery;
        this.data.name = `·  ${lottery.name}  ·`
       
        if(lottery.type == 'object'){
            this.img.width = 250;
            this.img.height = 250;
            this.img.y = 380;
            this.objbg.visible = false;
            this.objlihua.visible = true;

        }else {
            this.img.width = this.picBigWidth;
            this.img.height = this.picBigWidth / this.bigPicRatio;
            this.objbg.visible = false;
            this.objlihua.visible = false;
        }

        this.tryGroup.visible = false;

        showCustomLog(lottery);
    }

    showTry(){
        let y = 400;
        this.tryGroup.visible = true;
        egret.Tween.get(this.tryGroup)
        .set({ y: y + 40, alpha: 0 })
        .to({ y: y, alpha: 1 }, 200)
        .to({ y: y, alpha: 1 }, 1600)
        .to({ y: y - 40, alpha: 0 }, 200);
    }
    
    initEvents() {
        super.initEvents();
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
        this.img.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onUse, this);
    }

    onUse() {
        console.log("点击按钮");
        const lottery = DataManager.ins.getCustomOrderStatusData.lottery;
        
        if(DataManager.ins.customCfgData.preview || window.location.hostname == "activity-5.m.duiba.com.cn"){
            // NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            // showAlertPanel("抱歉，本次为活动试玩，无法领取奖品，快去分享吧！");
            this.showTry();
            // this.hidePanel();
            return
        }

        if (lottery.type == LotteryType.COUPON || lottery.type == LotteryType.LUCKY) {
            window["downloadAppConfig"] =
                {
                    openUrl: lottery.openUrl,
                    iosDownloadUrl: lottery.iosDownloadUrl,
                    androidDownloadUrl: lottery.androidDownloadUrl,
                    confirm: lottery.confirm ? lottery.confirm : false
                };
            window["downloadApp"]();
            if (lottery.type == LotteryType.LUCKY) {
                NetManager.ins.spmclick(DataManager.ins.getCustomOrderStatusData.exposure);
            }
        }
        else {
            // 实物领奖
            console.log('实物领奖')
            // window.location.href = lottery.link;
            let activity = localStorage.getItem('activityId')
            // let uid = localStorage.getItem('visitId')
            window.location.href = window["gloal"].prizeUrl + `&uid=${CFG.uid}&activityId=${activity}&origins=${CFG.actId}00`;
        }
    }

    get picBigWidth() { return 512 };
    get bigPicRatio() { return 512 / 240 }

    get skinKey() { return 'Prize' }

    img: eui.Image;
    useBtn: eui.Button;

    protected get closeBtns(): eui.Button[] {
        return [this['closeBtn']]
    }
}