import { DataManager } from "../../tw/manager/DataManager";
import { NetManager } from "../../tw/manager/NetManager";
import ItemRenderder from "./OptionsItemRenderder";
import Panel from "./Panel";
import { ItemTypes, ItemTypesLit } from "../../../src/startScene/ItemTypes";
export default class OptionsPanel extends Panel {
    map = {};
    i = 0;
    start() {
        if (!DataManager.ins.ajaxElementData)
            NetManager.ins.ajaxElement(() => {
                this.updatePanel();
            });
        else
            this.updatePanel();
    }

    group: eui.Group;
    list: eui.List;
    updatePanel() {

        const scoreAreas = {
            '1,10': ItemTypes.box,
            '11,20': ItemTypes.egg,
            '21,30': ItemTypes.gift,
            '31,40': ItemTypes.gold,
            '41,50': ItemTypes.money,
        }
        const list = DataManager.ins.ajaxElementData.options.filter(i => i.prizeType != 'thanks' && i.prizeType != 'lucky');
        for (const i of list) {
            const type = scoreAreas[i.scoreArea];
            this.map[type] = this.map[type] || [];
            if (this.map[type].length < 4)
                this.map[type].push(i);
        }
        this.list.useVirtualLayout = false;
        this.list.itemRenderer = ItemRenderder;

        this.updateList();
    }

    ontapLeft() {
        this.i--;
        if (this.i < 0)
            this.i = 4;
        this.updateList();
    }

    ontapRight() {
        this.i++;
        if (this.i > 4)
            this.i = 0;
        this.updateList();
    }

    updateList() {
        this.updateIcon();

        const currType = ItemTypesLit[this.i];
        const list = this.map[currType] || [];
        if (this.list.dataProvider) {
            (this.list.dataProvider as eui.ArrayCollection).removeAll();
            (this.list.dataProvider as eui.ArrayCollection).source = list;
            (this.list.dataProvider as eui.ArrayCollection).refresh();
        } else {
            const ac = new eui.ArrayCollection(list);
            this.list.dataProvider = ac;
        }

    }

    updateIcon() {
        for (const key of ItemTypesLit) {
            this[key].visible = false;
        }
        this[ItemTypesLit[this.i]].visible = true;
    }

    leftBtn: eui.Button;
    rightBtn: eui.Button;
    initEvents() {
        super.initEvents();
        this.leftBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontapLeft, this);
        this.rightBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontapRight, this);
    }
    removeEvents() {
        super.removeEvents();
        this.leftBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontapLeft, this);
        this.rightBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontapRight, this);
    }

    get skinKey() { return 'Options' }
}