import { IDynamicData } from "../../tw/data/game/datapash/IDynamicData";
import { NetManager } from "../../tw/manager/NetManager";
import { DataManager } from "../../tw/manager/DataManager";


/**
 * 获取活动工具抽奖结果
 * @param callback 
 */
const getCustomOrderStatus = (callback: Function, orderID): void => {
    NetManager.ins.getCustomOrderStatus(callback, orderID, () => {
        return DataManager.ins.getCustomOrderStatusData.result == 0;
    });
}

/**
 * 提交游戏成绩
 * @param callback 
 * @param score 得分
 * @param checkScore  是否校验得分
 * @param customizedType 定制类型 1推币机    
 */
const hdGameSubmit = (callback: Function, score: number, checkScore?: boolean, customizedType?: number) => {
    const allDynamics = [];
    HDgameSubmitData(callback, score, allDynamics, checkScore, customizedType);
}

/**
* 提交游戏成绩
* @param callback 
* @param score 得分
* @param allDynamics 防作弊数据
* @param checkScore  是否校验得分
* @param customizedType 定制类型 1推币机    
*/
const HDgameSubmitData = (callback: Function, score: number, allDynamics: IDynamicData[][], checkScore?: boolean, customizedType?: number) => {
    NetManager.ins.hdGameSubmit(
        (success: boolean) => {
            if (success) {
                getCustomOrderStatus(callback, DataManager.ins.doJoinData.orderId);
            } else {
                callback(success);
            }
        },
        DataManager.ins.doJoinData.orderId,
        score,
        '[]',
        DataManager.ins._getHdStartStatusData.submitToken,
        JSON.stringify(allDynamics),
        checkScore,
        customizedType);
}

export default hdGameSubmit;