(function() {
  var host = location.hostname.indexOf("test") == -1 ? "kjj.m.duiba.com.cn" : "kjj.m.duibatest.com.cn";
  var kjj = {
    visitId: '',
    tku: '',
    scid: '',
    middlePage: 'https://activity-2.m.duiba.com.cn/customShare/share?id=2922',
    activityUrl: '//' + host + '/kjy/mp/activity',
    shareData: {
      debug: false,
      title: '',
      desc: '',
      link: '',
      imgUrl: 'http://yun.dui88.com/h5/miniprogram/kejiji/activity/yaoqing/img/o_1da61oupgk7k1o9tis11f06v653i.jpg',
      success: function(res) {},
      cancel: function(res) {}
    },

    init: function() {
      var self = this;
      this.parsingCookie(function() {
        self.accessCount();
        self.share();
      });
    },

    accessCount: function() {
      var self = this;
      var updateCount = 0;
      var updateInterval = setInterval(function() {
        if (updateCount <= 360 && self.visitId > 0) {
          self.updateDuration(function() {
            updateCount++;
          });
        } else {
          clearInterval(updateInterval);
        }
      }, 5000)
    },

    updateDuration: function(callback) {
      var self = this;
      $.ajax({
        url: 'https://' + host + '/kjy/mp/content/updateDuration',
        type: 'get',
        dataType: 'json',
        beforeSend: function(request) {
          request.setRequestHeader("tku", self.tku);
        },
        data: {
          visitId: self.visitId
        },
        cache: false,
        success(res) {
          callback && callback(res);
        }
      })
    },

    share: function() {
      var self = this;
      this.shareData = Object.assign({}, this.shareData, window.shareData);
      this.activityUrl += '?scid=' + this.getUrlParameter("scid");
      this.shareData.link = this.middlePage + "&url=" + encodeURIComponent(encodeURIComponent(this.activityUrl));
      // alert(JSON.stringify(this.shareData));
      this.invokeWX();
      // this.getOaJssdk(function(res) {
      //   wx.config({
      //     debug: self.shareData.debug,
      //     appId: res.data.appid,
      //     timestamp: res.data.timestamp,
      //     nonceStr: res.data.noncestr,
      //     signature: res.data.sign,
      //     jsApiList: ['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage']
      //   });
      // })
    },

    parsingCookie: function(callback) {
      var self = this;
      var dcustom = decodeURIComponent(this.getCookie('dcustom'));
      if (!dcustom) return;
      try {
        var arr = dcustom.split('{')[1].split('}')[0].split(',');
        arr.forEach(function(item) {
          if (item.indexOf("visitId") > -1) {
            self.visitId = item.split("=")[1];
          }
          if (item.indexOf("tku") > -1) {
            self.tku = item.split("=")[1];
          }
        });
      } catch(err) {

      }
      callback && callback();
    },

    getCookie: function(name) {
      var arr;
      var reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
      if (arr = document.cookie.match(reg)) return unescape(arr[2]);
      else return null;
    },

    getUrlParameter: function(name) {
      var path = window.location.href;
      const result = decodeURIComponent((new RegExp('[?|&]' + name + '=([^&;]+?)(&|#|;|$)').exec(path) || [undefined, ''])[1].replace(/\+/g, '%20')) || null;
      return result ? result: '';
    },

    getOaJssdk: function(callback) {
      var self = this;
      $.ajax({
        url: 'https://' + host + '/kjy/mp/seller/getOaJssdk',
        type: 'get',
        dataType: 'json',
        beforeSend: function(request) {
          request.setRequestHeader("tku", self.tku);
        },
        data: {
          url: window.location.href
        },
        cache: false,
        success(res) {
          if (res.success) {
            callback && callback(res);
          }
        }
      });
    },

    play: function(){
        // var voice = $("audio")[0]; 
        // voice.play();
    },

    invokeWX() {
      var self = this;
      wx.ready(function() {
        self.play();
        wx.onMenuShareTimeline({
          title: self.shareData.title,
          link: self.shareData.link,
          imgUrl: self.shareData.imgUrl,
          success: function(res) {
            self.shareData.success(res);
          },
          cancel: function() {
            self.shareData.cancel(res);
          }
        });
        wx.onMenuShareAppMessage({
          title: self.shareData.title,
          desc: self.shareData.desc,
          link: self.shareData.link,
          imgUrl: self.shareData.imgUrl,
          success: function(res) {
            self.shareData.success(res);
          },
          cancel: function(res) {
            self.shareData.cancel(res);
          },
          fail: function(res) {
            self.shareData.fail(res);
          }
        });
      })
    },

    getUserInfo: function(callback) {
      var self = this;
      var scid = this.getUrlParameter("scid");
      $.ajax({
        url: '//' + host + '/kjy/mp/seller/getInfoByScid',
        type: "GET",
        data: { scid: scid },
        beforeSend: function(request) {
          request.setRequestHeader("tku", self.tku);
        },
        success: function(res) {
          if (res.code == "100010") {
            var url = '//' + host + '/kjy/authorize/wxh5base?uri=' + encodeURIComponent(location.href);
            window.location.href = url;
            return;
          } else if (res.success) {
            callback && callback(res);
          } else {
            // alert(res.code);
          }
        },
        error: function(err) {
          // alert(err);
        }
      })
    }
  };
  window.kjj = kjj;
  window.kjj.init();
})();