import MItem from "../MComponents/MItem";
import { MUtils } from "../Global/MUtils";
import { createPropsCard, getPropsTypeName } from "../Global/GUtils";
import { MConfigs } from "../Global/MConfigs";

export default class SignInItem extends MItem {
    public labelDay: eui.Label;
    public signedMask: eui.Image;
    public imgSigned: eui.Image;
    public groupCard: eui.Group;
    public labelRewardName: eui.Label;
    data: {
        cardId: string,
        isSigned: boolean,
        dayNum: number
    }

    dataChanged() {
        this.labelDay.text = `第${this.data.dayNum}天`;

        this.groupCard.addChild(createPropsCard(this.data.cardId));
        this.labelRewardName.text = getPropsTypeName(MConfigs.props[this.data.cardId].type);

        if (this.data.isSigned) {
            this.signedMask.visible = true;
            this.imgSigned.visible = true;
        } else {
            this.signedMask.visible = false;
            this.imgSigned.visible = false;
        }
    }
}