import Panel from "../MViews/MPanel";
import { invokeWX, getGameViewSize } from "../Global/GUtils";
import Net from "../Global/Net";
import { NetUtils } from "../Global/NetUtils";
import { Decorator } from "../Decorator/Decorator";
import MTimer from "../MComponents/MTimer";

var longPress = false;
var timeOutHandle: number = null;

// @Decorator.OnUpdate
@Decorator.OnDestroy
export default class PostPanel extends Panel {
	get skinKey() { return "PostPanel" }
	public cutimg: eui.Image;
	public closeBtn: eui.Button;
	public erweima: eui.Image;

	public onClose: () => void = () => { };

	onSkinComplete() {
		super.onSkinComplete();

		//如果无法监听分享图片成功，则直接进入页面时加次数

		setTimeout(() => {
			this.getScreen();
		}, 500)
		document.getElementById('shareImg').style.display = "block";
		this.erweima.source = window['erweima'];
		this.closeBtn.onTap(this, () => {
			this.hidePanel();
			this.onClose();
			document.getElementById('shareImg').style.display = "none";
		});
	}
	// initEvents(){
	// 	this.closeBtn.onTap(this,()=>{
	// 		this.hidePanel()
	// 		document.getElementById('shareImg').style.display = "none";
	//     });
	// }

	//长按识别二维码
	getScreen() {
		setTimeout(() => {
			// let width = getGameViewSize().width;
			// console.error(width);
			let img = this.getPrintScreenData(this.cutimg, 0, 0, 750, this.stage.stageHeight);// this.stage.stageWidth,this.stage.stageHeight);
			// console.log(img);
			let shareImg = document.getElementById('shareImg');
			this.showImgByImgData(shareImg, img, 0, 100, 750, this.stage.stageHeight - 100, false);

			this.addLongListener(shareImg);
		}, 500);
	}

	private shareRequest() {
		let timestamp = NetUtils.getTimestamp();
		Net.sendPost(Net.uri.share, {
			timestamp: timestamp,
			token: NetUtils.md5(timestamp + "duiba4jxabc")
		}, () => { }, () => true);
	}

	onDestroy() {
		clearTimeout(timeOutHandle);
	}

	private frameTimer: number = 0;
	private addLongListener(shareImg: HTMLElement) {
		shareImg.addEventListener("touchstart", function (e: any) {
			clearTimeout(timeOutHandle);
			timeOutHandle = setTimeout(function () {
				let timestamp = NetUtils.getTimestamp();
				Net.sendPost(Net.uri.share, {
					timestamp: timestamp,
					token: NetUtils.md5(timestamp + "duiba4jxabc")
				}, () => { }, () => true);
			}, 500);
		});
		/* shareImg.addEventListener("touchmove", function () {
			clearTimeout(timeOutHandle);
		}); */
		shareImg.addEventListener("touchend", function () {
			clearTimeout(timeOutHandle);
		});
	}

    /**
	 * 白鹭截canvas为img
	 * @param scene 当前场景
	 * @param startX 截图开始的x坐标 
	 * @param startY 截图开始的y坐标
	 * @param width 截图的宽度
	 * @param height 截图的高度
	 * return base64的png图片
	 */
	public getPrintScreenData(scene, startX, startY, width, height): any {
		let renderTexture: egret.RenderTexture = new egret.RenderTexture();
		renderTexture.drawToTexture(scene, new egret.Rectangle(startX, startY, width, height));
		// egret.updateAllScreens();
		let imageData = renderTexture.toDataURL("image/png");
		return imageData;
	}

	/**
	 * 将截图的图片展示到img标签，提供长按保存功能
	 * @param img dom的Img标签 document.getElementById('shareImg');
	 * @param imageData base64图片数据
	 * @param startX 截图的x
	 * @param startY 截图的y
	 * @param width 截图的宽度
	 * @param imgLoadCallBack 加载图片完成后的回调
	 */
	public showImgByImgData(img: any, imageData: string, startX: number, startY: number, width: number, height: number, isVisible: boolean, imgLoadCallBack?: Function): any {
		img.style.position = 'absolute';
		let widthP = width / this.stage.stageWidth;
		img.style.width = `${widthP * 100}%`;

		let heightP = height / this.stage.stageHeight;
		img.style.height = `${heightP * 100}%`;

		let leftP = startX / this.stage.stageWidth;
		img.style.left = `${leftP * 100}%`;
		let topP = startY / this.stage.stageHeight;
		img.style.top = `${topP * 100}%`;
		if (isVisible) {
			img.style.opacity = 1;
		} else {
			img.style.opacity = 0;
		}
		img['src'] = imageData;
		img.onload = imgLoadCallBack ? imgLoadCallBack : () => { };
	}

}
