import { Decorator } from "../Decorator/Decorator";
import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import MainScene from "../Scene/MainScene";
import Loading from "../../loading/Loading";
import SceneCtrl from "../MCtrls/MSceneCtrl";
import StartScene, { SharePanel } from "../Scene/StartScene";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import UsePropsPanel from "./UsePropsPanel";
import ToastPanel from "../MComponents/MToastPanel";
import { MConfigs } from "../Global/MConfigs";
import CommonPanel from "./CommonPanel";
import GameMgr from "../Mgr/GameMgr";
import { showSharePanel } from "../Global/GUtils";

@Decorator.ClassName("GameOverPanel")
@Decorator.OnUpdate
export default class GameOverPanel extends Panel implements Decorator.IDefaultCallback {
    public btnClose: MButton;
    public labelScore: eui.Label;
    public labelTopScore: eui.Label;
    public btnRestart: MButton;
    public btnUseProps: MButton;
    private context: MainScene;
    private timestamp: number = null;

    constructor() {
        super();
        this.timestamp = egret.getTimer();
    }

    init(context: MainScene) {
        this.context = context;
    }

    onUpdate() {
        if (egret.getTimer() - this.timestamp > MConfigs.GameOverPanelStayTime) {
            this.onClose();
        }
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.onClose();
        });

        this.labelScore.text = this.context.score.toString();
        const maxScore = this.context.maxScore;
        this.labelTopScore.text = typeof this.context.maxScore == "number" ? maxScore.toString() : "-";

        this.btnRestart.onTap(this, () => {
            this.onClose();
        });

        this.btnUseProps.onTap(this, () => {
            PanelCtrl.instance.show<UsePropsPanel>(UsePropsPanel).init(
                this,
                this.context,
                (id) => {
                    if (typeof id == "string") { //使用的是加分卡
                        this.context.finalSubmit(id, () => {
                            ToastPanel.show("加分成功", true, () => {
                                PanelCtrl.instance.closeAll();
                                this.onTurnStart();
                            });
                        });
                    } else { //使用的是复活卡
                        this.hidePanel();
                    }
                }
            );
        });
    }

    public onClose() {
        PanelCtrl.instance.closeAll();
        this.context.finalSubmit(undefined, () => {
            this.onTurnStart();
        });
    }

    private onTurnStart() {
        if (GameMgr.instance.gameCount <= 0) {
            showSharePanel();
        } else {
            SceneCtrl.instance.change(StartScene);
        }

    }

    /* private showSharePanel() {
        let obj = {
            title: "",
            content: "今天次数已用完  明天再来吧~",
            btnText: "知道了"
        }
       
    } */
}