import Pool from "../MComponents/Pool";
import Bullet from "../Game/Bullet";
import { MConst } from "../Global/MConst";
import PoolMgr from "./PoolMgr";
import MainScene from "../Scene/MainScene";

export default class ParticleMgr extends PoolMgr<Bullet> {
    constructor(layer: egret.DisplayObjectContainer) {
        super(layer);
        this.containRect = new egret.Rectangle(- 100, - 100, MConst.DesignResolution.x + 100, MConst.DesignResolution.y + 100);
    }

    createElement([context]: [MainScene]) {
        let b = new Bullet(context);
        b.physics.onMoved.add(() => {
            if (!this.containRect.contains(b.x, b.y)) {
                this.destroy(b);
            }
        });
        this.layer.addChild(b);
        return b;
    }

    create(context: MainScene) {
        return super.create(context);
    }

    private containRect: egret.Rectangle = null;
}