import MoveObjcet from "./MoveObject";
import { MConfigs } from "../Global/MConfigs";
import MainScene from "../Scene/MainScene";
import Collider, { CircleCollider, ColliderGroup } from "./Collider";
import { PoolElement } from "../MComponents/Pool";
import MTweenMgr from "../MComponents/MTween";
import SoundMgr from "../Mgr/SoundMgr";

/**掉落物 */
export default class Drop extends MoveObjcet implements PoolElement {
    private type: string = null;
    private label: eui.Label = null;
    public bitmap: egret.Bitmap = null;
    private scoreValue: number = null;
    private collider: CircleCollider = null;
    private isGround: boolean = false;
    private stayGroundCount = 0;

    constructor(context: MainScene) {
        super(context);
        //图像
        let bitmap = new egret.Bitmap();
        this.addChild(bitmap);
        this.bitmap = bitmap;

        //文字
        let label = new eui.Label();
        label.size = 24;
        this.addChild(label);
        this.label = label;
        this.collider = this.addComponent<CircleCollider>(CircleCollider);
        this.collider.group = ColliderGroup.Drop;

        this.cacheAsBitmap = true;
    }

    init(id: number) {
        let config: {
            type: string,
            value: number,
            textColor: number,
            fileIndex: string
        } = MConfigs.drop[id];

        this.type = config.type;
        this.scoreValue = config.value;
        this.physics.acceleration.y = 0.3;

        let texture = RES.getRes(`drop_${config.type}_${config.fileIndex}_png`) as egret.Texture;
        this.bitmap.texture = texture;

        let str = "+" + config.value;
        if (config.type == "power") str = str + "%";
        let label = this.label;
        label.text = str;
        label.textColor = config.textColor;
        label.visible = false;
        label.x = texture.textureWidth + 2;
        label.y = texture.textureHeight / 2 - label.height / 2;

        this.collider.setData(texture.textureWidth / 2, texture.textureHeight / 2, texture.textureWidth / 2);

        let onceBlink = () => {
            MTweenMgr.instance.get(this).to({ alpha: 0 }, 2, true).to({ alpha: 1 }, 2, true).call(onceBlink);
        };
        MTweenMgr.instance.get(this).wait(3000, false).call(onceBlink);
        MTweenMgr.instance.get(this).wait(5000, false).call(() => {
            MTweenMgr.instance.removeTweens(this);
            this.context.dropPool.destroy(this)
        });

        return this;
    }

    /**被炮车吃了 */
    private eated() {
        SoundMgr.instance.playEffect("collect_mp3");
        this.physics.rotateVelocity = 0;
        this.rotation = 0;
        this.physics.enabled = false;
        this.getComponent(CircleCollider).enabled = false;
        this.label.visible = true;
        if (this.type == "bullet") {
            this.context.bulletScore += this.scoreValue;
        } else if (this.type == "power") {
            this.context.powerScore += this.scoreValue;
        }

        MTweenMgr.instance.removeTweens(this);
        MTweenMgr.instance.get(this)
            .to({ y: this.y - 200, alpha: 0 }, 1000, false)
            .call(() => {
                this.context.dropPool.destroy(this);
            });
    }

    onCollisionEnter(other: Collider) {
        if (other.group == ColliderGroup.Car) {
            this.eated();
        }

        if (other.group == ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount = 0;
            this.physics.velocity.y = -(this.physics.velocity.y * 0.5);
        }

        if (other.group == ColliderGroup.Wall) {
            this.physics.velocity.x = - this.physics.velocity.x;
            if (this.isGround) {
                this.physics.rotateVelocity = -this.physics.rotateVelocity
            }
        }
    }

    onCollisionStay(other: Collider) {
        if (other.group == ColliderGroup.Ground && !this.isGround) {
            this.stayGroundCount++;
            if (this.stayGroundCount > 2) {
                this.isGround = true;
                this.physics.velocity.y = 0;
                this.physics.acceleration.y = 0;
                this.physics.velocity.x *= 0.5;

                let radius = (this.physics.collider as CircleCollider).radius;
                this.physics.rotateVelocity = this.physics.velocity.x * (180 / (Math.PI * radius));
            }
        }
    }

    onCollisionExit(other: Collider) {
        if (other.group == ColliderGroup.Ground) {
            this.stayGroundCount = 0;
        }
    }

    onElementInit() {
        this.alpha = 1;
        this.visible = true;
        this.stayGroundCount = 0;
        this.isGround = false;
        this.enableAllComponents();
    }

    onElementRecycle() {
        this.visible = false;
        this.disableAllComponents();
    }
}