import { PoolElement } from "../MComponents/Pool";
import MoveObjcet from "./MoveObject";
import { MConst } from "../Global/MConst";
import GameObject from "./GameObject";
import Collider, { CircleCollider, ColliderGroup } from "./Collider";
import ParticleMgr from "../Mgr/ParticleMgr";
import MainScene from "../Scene/MainScene";

/**
 * 子弹类
 */
export default class Bullet extends MoveObjcet implements PoolElement {
    public power: number = 1;

    constructor(context: MainScene) {
        super(context);
        this.addChild(new egret.Bitmap(RES.getRes("bullet_png")));
        this.anchorY = 0;

        let collider = this.addComponent(CircleCollider) as CircleCollider;
        collider.group = ColliderGroup.Bullet;
        collider.setData(2, 0, 6);
        this.physics.velocity.y = -MConst.BulletSpeedValue;
    }

    init(power: number) {
        this.power = power;
        return this;
    }

    onElementInit() {
        this.enableAllComponents();
        this.visible = true;
    }
    onElementRecycle() {
        this.disableAllComponents();
        this.visible = false;
    }

    onCollisionEnter(other: Collider) {
        if (other.group == ColliderGroup.Ball || other.group == ColliderGroup.Top) {
            this.context.bulletPool.destroy(this);
        }
    }
}