declare interface String {
    isUpperCase(): boolean;
    isLowerCase(): boolean;
}

declare interface Array<T> {
    remove(element: T): Array<T>;
}

declare interface Math {
    clamp(target: number, min: number, max: number): number;
}

declare namespace egret {
    namespace Timer {
        const deltaTime: number;
    }

    interface EventDispatcher {
        onTap(target: any, callback: () => void): void;
    }

    interface DisplayObject extends EventDispatcher {
        destroy(): void;
    }
}

declare class SVGAMovieClip extends egret.DisplayObject {
    constructor(videoItem: any);
    gotoAndPlay(pos: number, unknownParam: boolean): void;
    gotoAndStop(pos: number): void;
    readonly currentFrame: number;
    readonly totalFrames: number;
}