
import Panel from "../views/Panel";
import DogData from "../startScene/DogData";
export default class Share2Panel extends Panel {
  
    private mdata:any;

    public get skinKey() { return 'Share2' }
	public get groupName() { return 'share2_panel'}
    constructor(data?){
        super(data);
        this.mdata = data;
    }

    start(data?):void{
        this.percentHeight = 100;
    }

    initEvents():void{
        // this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    removeEvents():void{
        // this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
    }

    onSkinComplete(): void {
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad():void{
        this.erweimaImg.visible = false;
        this.dogImg.source = 'dog_lv_' + (this.mdata.level) + '_png';
        this.dogImg.anchorOffsetX = DogData.getSizeData[this.mdata.level - 1][0] * 0.5;
        this.dogImg.anchorOffsetY = DogData.getSizeData[this.mdata.level - 1][1];

        this.dogImg.x = 750 * 0.5;
        this.dogImg.y = this.dogShadowImg.y;

        this.titleLb.text = '我在萌宠汪星球领养了' + this.mdata.dNum + '只狗狗';

        
        setTimeout(() => {
            this.scanImg();
        }, 1000);

        //img.style.display = 'none';//block
    }


    private scanImg():void{
        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(this.panelGroup, new egret.Rectangle(0, 0, 750, 1206));
        let imageData = renderTexture.toDataURL("image/png");
        var img = document.getElementById('shareImg');
        img.style.position = 'absolute';
        img['src'] = imageData;
        
        img.style.width = "100%";//`${widthP}%`;
        img.style.left  = "0%";//`${leftP}%`;
        img.style.top   = "0%";//`${topP}%`;

        var sCloseBtn = document.getElementById('sCloseBtn');
        sCloseBtn.style.width       = '50px';
        sCloseBtn.style.height      = '50px';
        sCloseBtn.style.position    = 'absolute';
        sCloseBtn.style.top         = '40px';
        sCloseBtn.style.left        = '40px';

        img.style.display           = 'block';
        sCloseBtn.style.display     = 'block';

        sCloseBtn.onclick = ()=>{
            img.style.display = 'none';
            sCloseBtn.style.display = 'none';
            this.hidePanel();
        }
    }
}