import Panel from "../views/Panel";
import { MConfigs } from "../MConfigs";
import AchievementPicItem from "../item/AchievementPicItem";

export default class ViewAchievementPanel extends Panel {
    public get skinKey() { return "ViewAchievementPanel" }
    public get groupName() { return "view_achievement_panel" }

    public date: eui.Label;
    public achievementName: eui.Label;
    public picContainer: eui.DataGroup;

    protected preLoadRes() {
        return new Promise(async (resolve, reject) => {
            await RES.loadGroup(this.groupName);
            resolve();
        });
    }

    private achievementPicItem: AchievementPicItem = null;

    protected onSkinComplete() {
        super.onSkinComplete();
        console.log(this.data.configData)
        console.log(this.data.gmtCreate)
        var timestamp1 = Date.parse(this.data.gmtCreate);
        var timestamp2 = (this.data.gmtCreate).valueOf();
        var timestamp3 = this.data.gmtCreate.getTime();
        console.log(timestamp1+"."+timestamp2+"."+timestamp3)
      //  let configData = this.data["id"];
        this.achievementName.text = this.data.configData["name"];
        this.picContainer.addChild(new AchievementPicItem(this.data.index));
    }
}