import Panel from "../views/Panel";
import { NetBuried } from "../NetBuried";
import { NetPromise } from "../NetPromise";

export default class LearnedMusicPanel extends Panel {
    public get skinKey() { return "LearnedMusicPanel" }
    public btnOk: eui.Button;
    public musicName: eui.Label;
    public singerName: eui.Label;
    public iconArea: eui.Image;

    onSkinComplete() {
        super.onSkinComplete();
        NetBuried.ins.showLog(28)
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, this.hidePanel, this);
        this.musicName.text = this.data["musicName"];
        this.singerName.text = this.data["singerName"];
        this.iconArea.source = this.data["pic"];
    }

    initEvents(){
        super.initEvents()
        this.iconArea.addEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    removeEvents(){
        super.removeEvents()
        this.iconArea.removeEventListener(egret.TouchEvent.TOUCH_TAP,this.onTap_iconArea,this)
    }

    onTap_iconArea(){
        console.log(this.data.data)
        let _data=this.data.data.song;
        NetPromise.ins.handlePlay({
            album: _data.album,
            artist: _data.artist,
            formats: _data.formats,
            fsongname: "",
            hasmv: false,
            isdownload: 0,
            kmark: "",
            musicrid: _data.musicrid,
            name: _data.name,
            nationid: _data.nationid,
            online: _data.online,
            pay:  _data.pay,
            psrc: "h5app_worldcup"
        })
    }

    /**
     * @param data
     */
    constructor(data: any) {
        super(data);
    }


    hidePanel(){
        NetBuried.ins.clickLog(28)
        super.hidePanel()
        this.data.callback()
    }
}