import { MUtils } from "../MUtils";
import MItem from "../components/MItem";
import { NetPromise } from "../NetPromise";

export default class ScoreItem extends MItem {
    public avatarGroup:eui.Group;
    public pic:eui.Image;
    public picMask:eui.Rect;
    public musicName:eui.Label;
    public singer:eui.Label;
    public btnPlay:eui.Button;
    public labelPlay:eui.Label;
    public lableMask:eui.Rect;

    private readonly playingColor: number = 0xfbc1c5;
    private readonly playColor: number = 0xfdfefe;

    private isPlaying = false;

    private async updatePlayState() {
       /*  if (this.isPlaying) {
            this.labelPlay.textColor = this.playingColor;
            MUtils.setButtonImage(this.btnPlay, await RES.getResAsync("score_playing_png"));
        } else {
            this.labelPlay.textColor = this.playColor;
            MUtils.setButtonImage(this.btnPlay, await RES.getResAsync("score_play_png"));
        } */
    }

    dataChanged() {
        this.musicName.text = this.data["musicName"];
        this.singer.text = this.data["singer"];
        this.pic.source = this.data["pic"];
        this.pic.mask=this.picMask;
        this.musicName.mask=this["lableMask0"];
        this.singer.mask=this.lableMask;
        this.updatePlayState();
        this.doRoll()
    }

    musicNameLoop
    singerLoop

    doRoll(){
        if(this.musicNameLoop){
            console.log(this.musicName.text)
            egret.Tween.removeTweens(this.musicName)
            this.musicName.x=103
        }
        if(this.musicName.width>this.lableMask.width){
            this.musicName.x=this.lableMask.x+this.lableMask.width;
            this.musicNameLoop = egret.Tween.get( this.musicName, { loop:true} );
            this.musicNameLoop.to( {x:-this.musicName.width}, 10000 ).call( ()=>{
            })
        }
        if(this.singerLoop){
            egret.Tween.removeTweens(this.singer)
            this.singer.x=102
        }
        if(this.singer.width>this.lableMask.width){
            this.singer.x=this.lableMask.x+this.lableMask.width;
            this.singerLoop = egret.Tween.get( this.singer, { loop:true} );
            this.singerLoop.to( {x:-this.singer.width}, 10000 ).call( ()=>{
            })
        }
    }


    protected onSkinComplete() {
        this.btnPlay.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickPlay, this);
        this.labelPlay.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickPlay, this);
    }

    private onClickPlay() {
        this.isPlaying = !this.isPlaying;
        this.updatePlayState();
        let _data=this.data["dataThis"]
        console.log("_data")
        console.log(_data)
        console.log(this.data)
        NetPromise.ins.handlePlay({
            album: _data.album,
            artist: _data.artist,
            formats: _data.formats,
            fsongname: "",
            hasmv: false,
            isdownload: 0,
            kmark: "",
            musicrid: _data.musicrid,
            name: _data.name,
            nationid: _data.nationid,
            online: _data.online,
            pay:  _data.pay,
            psrc: "h5app_worldcup"
        })
    }
}