import MItem from "../components/MItem";
import { MConfigs } from "../MConfigs";
import { MUtils } from "../MUtils";
import QuestListPanel from "../QuestListPanel/QuestListPanel";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class QuestListItem extends MItem {
    public btn: eui.Button;
    public questName: eui.Label;
    /**奖品的文字标签 */
    public reward: eui.Label;
    public labelProgress: eui.Label;

    private btnCallbck: () => void = () => { }
    private rewardId: number = null;

    dataChanged() {
        let config = MConfigs.quest[this.data["id"]];
        this.questName.text = config["name"];
        this.reward.text = config["reward"];
        if (config["maxTime"]) {
            this.labelProgress.visible = true;
            this.labelProgress.text = `${this.data["completedCount"]}/${this.data["dailyLimitCount"]}`;
            //if()
        } else {
            this.labelProgress.visible = false;
        }

        this.btn.enabled = true;

        let buttonImageName = "";
        switch (this.data["status"]) {
            case 0: //去完成
                this.btnCallbck = () => {
                    config["todo"]();
                    (this.data["context"] as QuestListPanel).hidePanel();
                };
                buttonImageName = "quest_list_btn_todo_png";
                break;
            case 1: //进行中
                this.btnCallbck = () => {
                    config["todo"]();
                    (this.data["context"] as QuestListPanel).hidePanel();
                };
                buttonImageName = "quest_list_btn_doing_png";
                break;
            case 2: //可领取
                this.rewardId = this.data["rewardId"];
                buttonImageName = "quest_list_btn_receive_png";
                console.log("this.rewardId")
                console.log(this.data.type)
                if(this.data.type!="4"){
                    this.btn.enabled = false;
                }
                this.btnCallbck = () => {
                    console.error("领取奖励", this.rewardId);
                }
                break;
            case 3: //已完成
                this.btn.enabled = false;
                buttonImageName = "quest_list_btn_done_png";
                break;
            default:
                console.error("invalid code");
                break;
        }
        MUtils.setButtonImage(this.btn, RES.getRes(buttonImageName));
    }

    onSkinComplete() {
        this.btn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.btnCallbck, this);
    }
}