import { NetManager } from "../libs/tw/manager/NetManager";
import { DataManager } from "../libs/tw/manager/DataManager";
import { NetName } from "../libs/tw/enum/NetName";
import { MConfigs } from "./MConfigs";


export class NetPromise {
    private static instance: NetPromise;

    public static get ins(): NetPromise {
        if (!this.instance) {
            this.instance = new NetPromise();
        }
        return this.instance;
    }

    constructor() {}


    pets=[]

    /**
     * 查询宠物信息
     */
    getPetInfoKuwo(){
		return new Promise((resolve,reject)=>{
			NetManager.ins.getPetInfoKuwo((success)=>{
				if(!success){
                    reject(success)
				}
				resolve(success)
			},window["CFG"].activityId)
		})
    }

    /**
     * 宠物交互
     * @param petId 
     * @param type 
     */
    petInteractionKuwo(petId,type){
        return new Promise((resolve,reject)=>{
            NetManager.ins.petInteractionKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                MConfigs.lastReq="pet"
                resolve(success)
            },petId,type,window["eduSignId"])
        })
    }

    /**
     * 查询签到信息
     * @param signActivityId 
     */
    getSignInfoKuwo(signActivityId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getSignInfoKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },signActivityId)
        })
    }

    /**
     * 签到
     * @param signActivityId 
     */
    doSign(signActivityId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.doSign((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },signActivityId)
        })
    }

     /**
     * 获取任务
     * @param signActivityId 
     */
    getTaskInfoKuwo(eduSignId,petId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getTaskInfoKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },eduSignId,petId)
        })
    }

    /**
     * 成就墙
     * @param signActivityId 
     */
    getEvolutionRecordKuwo(eduSignId,petId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getEvolutionRecordKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },eduSignId,petId)
        })
    }

    /**
     * 获取乐谱
     * @param signActivityId 
     */
    getKuwoMusicScoreKuwo(eduSignId,pageSize,pageNo){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getKuwoMusicScoreKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },eduSignId,pageSize,pageNo)
        })
    }

    /**
     * 获取音乐学习成果接口
     * @param signActivityId 
     */
    getLearnMusicHarvestKuwo(petId,eduSignId,loginUid,sid){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getLearnMusicHarvestKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                MConfigs.lastReq="music"
                resolve(success)
            },petId,eduSignId,loginUid,sid)
        })
    }

     /**
     * 完成任务成果接口
     * @param signActivityId 
     */
    completeTaskKuwo(eduSignId,type){
        return new Promise((resolve,reject)=>{
            NetManager.ins.completeTaskKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },eduSignId,type)
        })
    }

    /**
     * 待收藏歌曲列表接口
     * @param loginUid 
     * @param sid 
     */
    forFavor(loginUid,sid){
        return new Promise((resolve,reject)=>{
            NetManager.ins.forFavor((success)=>{
                let data=DataManager.ins.getData(NetName.FORFAVOR_KUWO)
                if(data.code!=200){
                    reject(success)
                }
                resolve(success)
            },loginUid,sid)
        })
    }

     /**
     * 收藏歌曲列表接口
     * @param loginUid 
     * @param sid 
     */
    likeSong(loginUid,sid,mid){
        return new Promise((resolve,reject)=>{
            NetManager.ins.likeSong((success)=>{
                let data=DataManager.ins.getData(NetName.LIKESONG_KUWO)
                if(data.code!=200){
                    reject(success)
                }
                resolve(success)
            },loginUid,sid,mid)
        })
    }

    /**
     * 插件抽奖
     * @param plActId 
     */
    doJoinPlugDraw(plActId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.doJoinPlugDraw((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },plActId)
        })
    }
    /**
     * 插件抽奖订单
     * @param orderId 
     */
    getPlugOrderStatus(orderId){
        return new Promise((resolve,reject)=>{
            NetManager.ins.getPlugOrderStatus((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },orderId,() => DataManager.ins.getPlugOrderStatusData.result == 0,10)
        })
    }


    /**
     * 插件抽奖订单
     * @param orderId 
     */
    detailKuwo(){
        return new Promise((resolve,reject)=>{
            NetManager.ins.detailKuwo((success)=>{
                if(!success){
                    reject(success)
                }
                resolve(success)
            },window["relType"],window["relId"])
        })
    }
    


    

     /**
     * 酷我数据初始化列表接口
     * @param loginUid 
     * @param sid 
     */
    initKuwo(loginUid,sid){
        return new Promise((resolve,reject)=>{
            NetManager.ins.initKuwo((success)=>{
                let data=DataManager.ins.getData(NetName.INIT_KUWO)
                if(data.code!=200){
                    reject(success)
                }
                resolve(success)
            },loginUid,sid,window["appuid"],window["plat"],"")
        })
    }

    /**
     * 分享功能
     */
    handleShare() {
        let title="发现一个好玩的小游戏，推荐你！"
        let desc="看看我在“酷小我出道记”里的表现，有惊喜呦！"
        return new Promise((resolve,reject)=>{
            window["kuwoApi"].share({
            imgurl:'https://yun.duiba.com.cn/db_games/activity/kwyyyc_20190809/share.jpg',
            imageurl:'https://yun.duiba.com.cn/db_games/activity/kwyyyc_20190809/share.jpg',
            url: `https://activity.m.duiba.com.cn/customShare/share?id=3490&appId=${window["CFG"].appId}&activityId=${window["CFG"].activityId}`,
            weibo: title,
            qqspace: title,
            qqspaceTitle: title,
            qqfriend: desc,
            qqfriendTitle: title,
            wxmsg: title,
            wxdes: desc,
            needconfirm: '0',
            callback: function(res) {
                //r(res);
                console.log('kwShare', res);
                resolve()
            }
            });
        })
    };

    /**
     * 播放音乐
     * @param data 
     */
    handlePlay(data) {
        window["kuwoApi"].play({
          index: 0,
          isplayall: false,
          libpath: "worldcup",
          listpic: "",
          listtitle: "",
          musiclist: [data],
          callback: (res)=>{
            console.log('play', res);
          }
        });
      }
}