import Panel from "../MViews/MPanel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";

interface DataType {
    imgUrl: string,
    name: string,
    receiveUrl: string,
    onClose?: () => void
}

export default class WinnigPanel extends Panel {
    get skinKey() { return "WinnigPanel" }
    public labelReward: eui.Label;
    public btnReceive: MButton;
    public imgReward: eui.Image;
    public btnClose: MButton;

    data: DataType;

    onSkinComplete() {
        super.onSkinComplete();

        this.labelReward.text = `获得${this.data.name}奖励`;
        this.imgReward.source = this.data.imgUrl;
        this.btnReceive.onTap(this, () => {
            this.hidePanel();
            this.data.onClose && this.data.onClose();
            window.location.href = this.data.receiveUrl;
        });
        this.btnClose.onTap(this, () => {
            this.hidePanel();
            this.data.onClose && this.data.onClose();
        });
    }

}