import Panel from "../MViews/MPanel";
import { Decorator } from "../Decorator/Decorator";
import MButton from "../MUI/MButton";
import MItem from "../MComponents/MItem";
import { createPropsCard, getPropsTypeName } from "../Global/GUtils";
import { MConfigs } from "../Global/MConfigs";
import Net from "../Global/Net";
import ToastPanel from "../MComponents/MToastPanel";
import { NetUtils } from "../Global/NetUtils";
import MainScene from "../Scene/MainScene";
import { MConst } from "../Global/MConst";
import Loading from "../../loading/Loading";
import GameOverPanel from "./GameOverPanel";

@Decorator.ClassName("UsePropsPanel")
export default class UsePropsPanel extends Panel {
    public btnClose: MButton;
    public dataGroup: eui.DataGroup;
    private onSelected: (id?: string) => void;
    private mainScene: MainScene = null;
    private context: GameOverPanel = null;
    private labelNothing: eui.Label;

    init(context: GameOverPanel, mainScene: MainScene, onSelected: (id?: string) => void) {
        this.context = context;
        this.mainScene = mainScene;
        this.onSelected = onSelected;
    }

    async preLoadRes() {
        await super.preLoadRes();
        // return RES.loadGroup("props");
    }

    onSkinComplete() {
        super.onSkinComplete();

        this.btnClose.onTap(this, () => this.hidePanel());
        this.dataGroup.itemRenderer = class extends MItem {
            public labelType: eui.Label;
            public btnUse: MButton;
            data: {
                id: string
                onSelect: () => void
            }

            dataChanged() {
                let card = createPropsCard(this.data.id);
                card.x = 35;
                card.y = 14;
                this.addChild(card);
                this.labelType.text = getPropsTypeName(MConfigs.props[this.data.id].type);
            }

            onSkinComplete() {
                this.btnUse.onTap(this, () => {
                    this.data.onSelect();
                });
            }
        };

        Net.sendGet(Net.uri.queryProps, {
            startId: this.mainScene.startId
        }, (res) => {
            let map = res.data.spMap as { [key: string]: number };
            let arr: {
                id: string,
                onSelect: () => void
            }[] = [];

            for (let id of Object.keys(map)) {
                for (let j = 1; j <= map[id]; j++) {
                    arr.push({
                        id: id,
                        onSelect: () => { //item的按钮被点击时的回调
                            if (res.data.leftUseSpCnt <= 0) { //后端剩余使用数量为0或者本地有记录待使用卡的id
                                ToastPanel.show("每局只能使用一次道具");
                            } else { //卡片可用
                                if (id == MConst.ReviveCardId) { //使用复活卡
                                    if (this.mainScene.timer <= 0) {
                                        ToastPanel.show("游戏时间已结束，无法复活");
                                        return;
                                    }

                                    //开启遮罩
                                    Loading.instace.show();
                                    //获取复活接口所需参数
                                    const startId = this.mainScene.startId;
                                    const seq = NetUtils.encryptSeq(this.mainScene.reviveSeq);
                                    //请求复活接口
                                    Net.sendPost(Net.uri.revive, {
                                        startId: startId,
                                        seq: seq,
                                        token: NetUtils.md5(startId.toString() + seq.toString() + "duiba4jxabc")
                                    }, () => { //成功
                                        this.mainScene.revive();
                                        Loading.instace.hide();
                                    }, ()=>{this.context.onClose()});

                                    this.onSelected(); //不带参数表示是复活卡
                                    this.hidePanel();
                                } else { //使用加分卡
                                    //调用回调函数通知上文提交最终分数
                                    this.onSelected(id);
                                }
                            }
                        }
                    });
                }
            }

            if (arr.length <= 0)
                this.labelNothing.visible = true;
            else
                this.dataGroup.dataProvider = new eui.ArrayCollection(arr);
        }, ()=>{this.context.onClose()});
    }

}