import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import SignInItem from "./SignInItem";
import { Decorator } from "../Decorator/Decorator";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import { MConfigs } from "../Global/MConfigs";
import { NetUtils } from "../Global/NetUtils";
import { createPropsCard, getPropsTypeName } from "../Global/GUtils";

export default class SignInPanel extends Panel {
    get skinKey() { return "SignInPanel" }
    public imgSignInDiabled: eui.Image;
    public btnSignIn: MButton;
    public btnClose: MButton;
    public dataGroup: eui.DataGroup;
    public sundayCardPlaceholder: eui.Group;
    public labelSundayRewardName: eui.Label;
    public groupSundayMask: eui.Group;
    public closeBtn:eui.Button;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => this.hidePanel());
        this.closeBtn.onTap(this, () => this.hidePanel());
        this.btnSignIn.onOnceTap(this, (resume) => {
            let timestamp = NetUtils.getTimestamp();
            Net.sendPost(Net.uri.signIn, {
                timestamp: timestamp,
                token: NetUtils.md5(timestamp + "duiba4jxabc")
            }, (res) => {
                let cycleDays = res.data.cycleDays;
                if (cycleDays <= 6) {
                    let item = this.dataGroup.getElementAt(cycleDays - 1) as SignInItem;
                    item.data = {
                        cardId: item.data.cardId,
                        isSigned: true,
                        dayNum: item.data.dayNum
                    }
                } else {
                    this.groupSundayMask.visible = true;
                }
                this.disableSignIn();
                resume();
            }, () => { resume() });
        });

        this.refresh();
    }

    private disableSignIn() {
        this.imgSignInDiabled.visible = true;
        this.btnSignIn.visible = false;
    }

    private refresh() {
        //处理后端数据
        let res = this.data.response;
        if (res.data.todayPopSignFlag & 1) { //已签到
            this.imgSignInDiabled.visible = true;
        } else {
            this.btnSignIn.visible = true;
        }

        const rewardList = res.data.rewardList as Array<string>;
        //单独处理第七天
        let sundayId = rewardList[rewardList.length - 1];
        this.sundayCardPlaceholder.addChild(createPropsCard(sundayId));
        this.labelSundayRewardName.text = getPropsTypeName(MConfigs.props[sundayId].type);

        this.dataGroup.itemRenderer = SignInItem;
        let arr: {
            cardId: string,
            isSigned: boolean,
            dayNum: number
        }[] = [];
        for (let i = 0; i < rewardList.length - 1; i++) {
            let isSign: boolean = false;
            if (i + 1 <= res.data.cycleDays) {
                isSign = true;
            }
            arr.push({
                cardId: rewardList[i],
                isSigned: isSign,
                dayNum: i + 1
            });
        }
        this.dataGroup.dataProvider = new eui.ArrayCollection(arr);

        this.groupSundayMask.visible = res.data.cycleDays >= 7;
        if (res.data.todayPopSignFlag & 1) {
            this.disableSignIn();
        }
    }
}