import Panel from "../MViews/MPanel";
import { HtmlTextParser } from "../../../libs/tc/util/HtmlTextParser";
import MButton from "../MUI/MButton";
import Net from "../Global/Net";
import { MConfigs } from "../Global/MConfigs";

export default class RulePanel extends Panel {
    get skinKey() { return "RulePanel" }
    public text: eui.Label;
    public btnClose: MButton;
    public closeBtn:eui.Button;
    data: {
        msg: string
    }

    onSkinComplete() {
        super.onSkinComplete();
        let ruledata = MConfigs.rule;
        this.text.textFlow = new HtmlTextParser().parse((ruledata) || testRule);
        this.btnClose.onTap(this, () => this.hidePanel());
        this.closeBtn.onTap(this, () => this.hidePanel());
    }

    getRule(){
        Net.sendGet(Net.uri.queryRule,undefined,(res)=>{
            if(res){
                this.text.textFlow = new HtmlTextParser().parse(res);

            }else{
                this.text.textFlow = new HtmlTextParser().parse((this.data && this.data.msg) || testRule);

            }
        })
    }

}

const testRule = `结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。
结构一节将帮助你了解常见库的格式以及如何为每种格式书写正确的声明文件。 如果你在编辑一个已经存在的文件，那么你可能不需要阅读此章节。 如果你在书写新的声明文件，那么你必须阅读此章节以理解库的不同格式是如何影响声明文件的书写的。`;